/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.pomegranate;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.fruits.FFDamageTypes;
import snownee.fruits.pomegranate.PomegranateModule;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.Explode;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class FFExplodeAction
extends Explode {
    public FFExplodeAction(Explosion.BlockInteraction blockInteraction, BlockPos offset, boolean fire, float radius, float step) {
        super(blockInteraction, offset, fire, radius, step);
    }

    public PostActionType<?> getType() {
        return (PostActionType)PomegranateModule.EXPLODE.get();
    }

    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Vec3 pos = (Vec3)ctx.getParam(LootContextParams.f_81460_);
        pos = pos.m_82520_((double)this.offset.m_123341_(), (double)this.offset.m_123342_(), (double)this.offset.m_123343_());
        float r = Math.min(this.radius + this.step * (Mth.m_14116_((float)times) - 1.0f), this.radius * 4.0f);
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.f_81455_);
        Entity causingEntity = null;
        if (entity instanceof TraceableEntity) {
            TraceableEntity traceable = (TraceableEntity)entity;
            causingEntity = traceable.m_19749_();
        }
        DamageSource damageSource = FFDamageTypes.explosion(ctx.getLevel().m_269111_(), entity, causingEntity);
        CommonProxy.explode((Explode)this, (ServerLevel)ctx.getServerLevel(), (Vec3)pos, (Entity)entity, (DamageSource)damageSource, null, (float)r);
    }

    public static class Type
    extends PostActionType<FFExplodeAction> {
        public FFExplodeAction fromJson(JsonObject o) {
            String s;
            BlockPos offset = CommonProxy.parseOffset((JsonObject)o);
            boolean fire = GsonHelper.m_13855_((JsonObject)o, (String)"fire", (boolean)false);
            Explosion.BlockInteraction blockInteraction = switch (s = GsonHelper.m_13851_((JsonObject)o, (String)"block_interaction", (String)"destroy")) {
                case "none", "keep" -> Explosion.BlockInteraction.KEEP;
                case "break", "destroy_with_decay" -> Explosion.BlockInteraction.DESTROY_WITH_DECAY;
                case "destroy" -> Explosion.BlockInteraction.DESTROY;
                default -> throw new IllegalArgumentException("Unexpected value: " + s);
            };
            float radius = GsonHelper.m_13820_((JsonObject)o, (String)"radius", (float)4.0f);
            float radiusStep = GsonHelper.m_13820_((JsonObject)o, (String)"radius_step", (float)0.5f);
            return new FFExplodeAction(blockInteraction, offset, fire, radius, radiusStep);
        }

        public void toJson(FFExplodeAction action, JsonObject o) {
            BlockPos offset = action.offset;
            if (offset.m_123341_() != 0) {
                o.addProperty("offsetX", (Number)offset.m_123341_());
            }
            if (offset.m_123342_() != 0) {
                o.addProperty("offsetY", (Number)offset.m_123342_());
            }
            if (offset.m_123343_() != 0) {
                o.addProperty("offsetZ", (Number)offset.m_123341_());
            }
            if (action.fire) {
                o.addProperty("fire", Boolean.valueOf(true));
            }
            if (action.blockInteraction != Explosion.BlockInteraction.DESTROY) {
                o.addProperty("block_interaction", action.blockInteraction.name().toLowerCase(Locale.ENGLISH));
            }
            if (action.radius != 4.0f) {
                o.addProperty("radius", (Number)Float.valueOf(action.radius));
            }
            if (action.step != 0.5f) {
                o.addProperty("radius_step", (Number)Float.valueOf(action.step));
            }
        }

        public FFExplodeAction fromNetwork(FriendlyByteBuf buf) {
            Explosion.BlockInteraction blockInteraction = (Explosion.BlockInteraction)buf.m_130066_(Explosion.BlockInteraction.class);
            BlockPos offset = buf.m_130135_();
            boolean fire = buf.readBoolean();
            float radius = buf.readFloat();
            float step = buf.readFloat();
            return new FFExplodeAction(blockInteraction, offset, fire, radius, step);
        }

        public void toNetwork(FFExplodeAction action, FriendlyByteBuf buf) {
            buf.m_130068_((Enum)action.blockInteraction);
            buf.m_130064_(action.offset);
            buf.writeBoolean(action.fire);
            buf.writeFloat(action.radius);
            buf.writeFloat(action.step);
        }
    }
}

