/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin.client;

import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeAttributes;

@Mixin(value={BeeRenderer.class})
public abstract class BeeRendererMixin
extends MobRenderer<Bee, BeeModel<Bee>> {
    public BeeRendererMixin(EntityRendererProvider.Context context, BeeModel<Bee> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(EntityRendererProvider.Context context, CallbackInfo ci) {
        if (!Hooks.bee) {
            return;
        }
        this.m_115326_((RenderLayer)new SaddleLayer((RenderLayerParent)((BeeRenderer)this), (EntityModel)new BeeModel(context.m_174023_(ModelLayers.f_171268_)), new ResourceLocation("fruitfulfun", "textures/entity/bee/bee_saddle.png")));
    }

    @Inject(method={"getTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTextureLocation(Bee bee, CallbackInfoReturnable<ResourceLocation> ci) {
        if (!Hooks.bee) {
            return;
        }
        BeeAttributes attributes = BeeAttributes.of(bee);
        ResourceLocation texture = attributes.getTexture();
        if (texture != null) {
            texture = texture.m_247266_($ -> {
                if (bee.m_21660_() && bee.m_27856_()) {
                    $ = (String)$ + "_angry_nectar";
                } else if (bee.m_21660_()) {
                    $ = (String)$ + "_angry";
                } else if (bee.m_27856_()) {
                    $ = (String)$ + "_nectar";
                }
                return "textures/entity/bee/" + (String)$ + ".png";
            });
            ci.setReturnValue((Object)texture);
        }
    }
}

