/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeAttributes;

@Mixin(value={LivingEntity.class})
public class RideableBeeLivingEntityMixin {
    @Inject(method={"getRiddenInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRiddenInput(Player player, Vec3 vec3, CallbackInfoReturnable<Vec3> ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Bee) {
            ci.setReturnValue((Object)Hooks.getRiddenInput((Bee)entity, player, vec3));
        }
    }

    @Inject(method={"getRiddenSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRiddenSpeed(Player player, CallbackInfoReturnable<Float> ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Bee) {
            float speed = (float)(entity.m_20096_() ? entity.m_21133_(Attributes.f_22279_) : entity.m_21133_(Attributes.f_22280_));
            ci.setReturnValue((Object)Float.valueOf(speed));
        }
    }

    @Inject(method={"tickRidden"}, at={@At(value="TAIL")}, cancellable=true)
    private void tickRidden(Player player, Vec3 vec3, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Bee) {
            Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
            entity.m_146922_(vec2.f_82471_ % 360.0f);
            entity.m_146926_(vec2.f_82470_ % 360.0f);
            entity.f_20883_ = entity.f_20885_ = entity.m_146908_();
            entity.f_19859_ = entity.f_20885_;
            ci.cancel();
        }
    }

    @Inject(method={"dropEquipment"}, at={@At(value="HEAD")})
    private void dropEquipment(CallbackInfo ci) {
        BeeAttributes attributes;
        ItemStack saddle;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Bee && !(saddle = (attributes = BeeAttributes.of(entity)).getSaddle()).m_41619_()) {
            entity.m_19983_(saddle);
            attributes.setSaddle(ItemStack.f_41583_);
        }
    }

    @Unique
    private Vec2 getRiddenRotation(LivingEntity livingEntity) {
        return new Vec2(livingEntity.m_146909_() * 0.5f, livingEntity.m_146908_());
    }
}

