/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.MutagenItem;

@Mixin(value={PotionBrewing.class})
public class PotionBrewingMixin {
    @Inject(method={"mix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mix(ItemStack ingredient, ItemStack container, CallbackInfoReturnable<ItemStack> ci) {
        if (PotionBrewingMixin.matchesMutagenRecipe(ingredient, container)) {
            ci.setReturnValue((Object)((MutagenItem)((Object)BeeModule.MUTAGEN.get())).randomMutagen(true, null));
        }
    }

    @Inject(method={"hasMix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasMix(ItemStack container, ItemStack ingredient, CallbackInfoReturnable<Boolean> ci) {
        if (PotionBrewingMixin.matchesMutagenRecipe(ingredient, container)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isIngredient"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isIngredient(ItemStack ingredient, CallbackInfoReturnable<Boolean> ci) {
        if (FFCommonConfig.isMutagenRecipeEnabled() && ingredient.m_150930_(MutagenItem.BREWING_ITEM)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Unique
    private static boolean matchesMutagenRecipe(ItemStack ingredient, ItemStack container) {
        if (!FFCommonConfig.isMutagenRecipeEnabled()) {
            return false;
        }
        if (!ingredient.m_150930_(MutagenItem.BREWING_ITEM)) {
            return false;
        }
        return container.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)container) == Potions.f_43599_;
    }
}

