/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.network.SSyncPlayerPacket;
import snownee.fruits.duck.FFPlayer;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements FFPlayer {
    @Unique
    private Map<String, FFPlayer.GeneName> geneNames = Map.of();

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (!this.geneNames.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<String, FFPlayer.GeneName> entry : this.geneNames.entrySet()) {
                ListTag nameTag = new ListTag();
                nameTag.add((Object)StringTag.m_129297_((String)entry.getKey()));
                nameTag.add((Object)StringTag.m_129297_((String)entry.getValue().name()));
                nameTag.add((Object)StringTag.m_129297_((String)entry.getValue().desc()));
                list.add((Object)nameTag);
            }
            compoundTag.m_128365_("FruitfulFun:GeneNames", (Tag)list);
            compoundTag.m_128359_("FruitfulFun:GeneticsDifficulty", FFCommonConfig.geneticsDifficulty.name());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        String code;
        if (compoundTag.m_128441_("FruitfulFun:GeneNames")) {
            for (Tag e : compoundTag.m_128437_("FruitfulFun:GeneNames", 9)) {
                ListTag nameTag = (ListTag)e;
                code = nameTag.m_128778_(0);
                String name = nameTag.m_128778_(1);
                String desc = nameTag.m_128778_(2);
                this.fruits$setGeneName(code, new FFPlayer.GeneName(name, desc));
            }
        }
        if (FFCommonConfig.geneticsDifficulty == FFCommonConfig.GeneticsDifficulty.Easy) {
            FFCommonConfig.GeneticsDifficulty difficulty = null;
            if (compoundTag.m_128441_("FruitfulFun:GeneticsDifficulty")) {
                try {
                    difficulty = FFCommonConfig.GeneticsDifficulty.valueOf(compoundTag.m_128461_("FruitfulFun:GeneticsDifficulty"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (difficulty != FFCommonConfig.geneticsDifficulty) {
                for (Allele allele : Allele.sortedByCode()) {
                    code = String.valueOf(allele.codename);
                    FFPlayer.GeneName geneName = this.geneNames.get(code);
                    if (geneName == null || !geneName.name().equals(code)) continue;
                    this.fruits$setGeneName(code, new FFPlayer.GeneName(allele.name, ""));
                }
            }
        }
    }

    @Override
    public String fruits$getGeneName(String code) {
        if (this.geneNames.containsKey(code)) {
            return this.geneNames.get(code).name();
        }
        return code;
    }

    @Override
    public String fruits$getGeneDesc(String code) {
        if (this.geneNames.containsKey(code)) {
            return this.geneNames.get(code).desc();
        }
        return "";
    }

    @Override
    public void fruits$setGeneName(String code, FFPlayer.GeneName name) {
        if (this.geneNames.isEmpty()) {
            this.geneNames = Maps.newHashMapWithExpectedSize((int)Allele.values().size());
        }
        this.geneNames.put(code, name);
    }

    @Override
    public Map<String, FFPlayer.GeneName> fruits$getGeneNames() {
        return this.geneNames;
    }

    @Override
    public void fruits$setGeneNames(Map<String, FFPlayer.GeneName> geneNames) {
        if (geneNames.isEmpty()) {
            this.geneNames = Map.of();
        } else {
            this.geneNames = Maps.newHashMapWithExpectedSize((int)geneNames.size());
            this.geneNames.putAll(geneNames);
        }
    }

    @Override
    public void fruits$maybeInitGenes() {
        boolean changed = false;
        for (Allele allele : Allele.sortedByCode()) {
            String code = String.valueOf(allele.codename);
            if (this.geneNames.containsKey(code)) continue;
            if (FFCommonConfig.geneticsDifficulty == FFCommonConfig.GeneticsDifficulty.Easy) {
                this.fruits$setGeneName(code, new FFPlayer.GeneName(allele.name, ""));
            } else {
                this.fruits$setGeneName(code, new FFPlayer.GeneName(code, ""));
            }
            changed = true;
        }
        if (changed) {
            SSyncPlayerPacket.send((ServerPlayer)this);
        }
    }
}

