/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.fruits.bee.BeeAttributes;

@Mixin(value={Mob.class})
public class MobMixin {
    @Inject(method={"onOffspringSpawnedFromEgg"}, at={@At(value="HEAD")})
    private void onOffspringSpawnedFromEgg(Player player, Mob mob, CallbackInfo ci) {
        if (mob instanceof Bee) {
            BeeAttributes.of(mob).addTrusted(player.m_20148_());
        }
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        Mob mob = (Mob)this;
        if (mob instanceof Bee) {
            Bee bee = (Bee)mob;
            BeeAttributes.of(bee).randomize(bee);
        }
    }
}

