/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.bee.network.SSyncBeePacket;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"startSeenByPlayer"}, at={@At(value="HEAD")})
    private void startSeenByPlayer(ServerPlayer player, CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            SSyncBeePacket.send(bee, player);
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void isInvulnerableTo(DamageSource source, CallbackInfoReturnable<Boolean> ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Bee && source == entity.m_269291_().m_269251_() && BeeAttributes.of(entity).hasTrait(Trait.WITHER_TOLERANT)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getPassengersRidingOffset"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPassengersRidingOffset(CallbackInfoReturnable<Double> ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Bee) {
            ci.setReturnValue((Object)((double)entity.m_20206_() * 0.6));
        }
    }
}

