/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.bee.network.SSyncBeePacket;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.duck.FFBee;

@Mixin(value={Bee.class})
public abstract class BeeMixin
extends Animal
implements FFBee {
    @Shadow
    private int f_27702_;
    @Unique
    private final BeeAttributes beeAttributes = new BeeAttributes();
    @Unique
    private int rollTicks;
    @Shadow
    private int f_27709_;
    @Shadow
    int f_27710_;

    public BeeMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Shadow
    protected abstract void m_27925_(boolean var1);

    @Override
    public BeeAttributes fruits$getBeeAttributes() {
        return this.beeAttributes;
    }

    @Override
    public void fruits$roll() {
        this.rollTicks = 6;
    }

    @Inject(at={@At(value="HEAD")}, method={"isFlowerValid"}, cancellable=true)
    private void isFlowerValid(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!Hooks.bee || !this.m_9236_().m_46749_(pos)) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_155947_() && state.m_60734_() instanceof FruitLeavesBlock) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        CompoundTag data = new CompoundTag();
        this.beeAttributes.toNBT(data);
        compoundTag.m_128365_("FruitfulFun", (Tag)data);
        compoundTag.m_128379_("RainCapable", BeeAttributes.of(this).hasTrait(Trait.RAIN_CAPABLE));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        Bee bee = (Bee)this;
        if (!(compoundTag = compoundTag.m_128469_("FruitfulFun")).m_128441_("Genes")) {
            this.beeAttributes.randomize(bee);
        }
        this.beeAttributes.fromNBT(compoundTag, bee);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Bee;updateRollAmount()V")})
    private void tick(CallbackInfo ci) {
        if (this.m_9236_().f_46443_ || !Hooks.bee) {
            return;
        }
        Bee bee = (Bee)this;
        MobEffectInstance effect = bee.m_21124_((MobEffect)BeeModule.MUTAGEN_EFFECT.get());
        BeeAttributes attributes = BeeAttributes.of(bee);
        long gameTime = this.m_9236_().m_46467_();
        attributes.setMutagenEndsIn(effect == null ? 0L : gameTime + (long)effect.m_19557_(), gameTime);
        if (this.beeAttributes.dirty) {
            this.beeAttributes.dirty = false;
            SSyncBeePacket.send(bee);
        }
        if (this.rollTicks > 0) {
            this.m_27929_(--this.rollTicks != 0);
        }
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")})
    private void customServerAiStep(CallbackInfo ci) {
        int healingInterval;
        if (!Hooks.bee) {
            return;
        }
        if (this.f_27702_ >= 20) {
            this.m_20153_();
        }
        if (this.m_27857_() && BeeAttributes.of(this).hasTrait(Trait.WARRIOR)) {
            if (this.f_27709_ == 0) {
                this.m_6469_(this.m_269291_().m_269264_(), 4.0f);
            } else if (!this.m_21224_() && this.f_19797_ % 10 == 0 && this.f_19796_.m_188503_(20) == 0) {
                this.m_27925_(false);
                this.f_27709_ = 0;
            } else {
                this.f_27709_ = 3;
            }
        }
        if (!this.m_21224_() && this.m_21223_() < this.m_21233_() && (healingInterval = FFCommonConfig.beeNaturalHealingInterval) > 0 && this.f_19796_.m_188503_(healingInterval) == 0) {
            this.m_5634_(1.0f);
        }
    }

    @Shadow
    protected abstract void m_27929_(boolean var1);

    @Shadow
    public abstract boolean m_27857_();

    @ModifyExpressionValue(method={"wantsToEnterHive"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isRaining()Z")})
    private boolean wantsToEnterHive(boolean original) {
        return original && !BeeAttributes.of(this).hasTrait(Trait.RAIN_CAPABLE);
    }

    @Inject(method={"isTiredOfLookingForNectar"}, at={@At(value="HEAD")}, cancellable=true)
    private void isTiredOfLookingForNectar(CallbackInfoReturnable<Boolean> cir) {
        if (this.f_27710_ > 1800 && BeeAttributes.of(this).hasTrait(Trait.LAZY)) {
            cir.setReturnValue((Object)true);
        }
    }
}

