/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.levelgen.foliageplacers;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import snownee.fruits.CoreModule;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.mixin.forge.FoliagePlacerAccess;

public class Fruitify
extends FoliagePlacer {
    public static final Codec<Fruitify> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FoliagePlacer.f_68519_.fieldOf("wrapped").forGetter($ -> $.wrapped), (App)Codec.BOOL.optionalFieldOf("worldgen", (Object)false).forGetter($ -> $.worldgen)).apply((Applicative)instance, Fruitify::new));
    private final FoliagePlacer wrapped;
    private final boolean worldgen;

    public Fruitify(FoliagePlacer wrapped, boolean worldgen) {
        super(wrapped.f_68520_, wrapped.f_68521_);
        this.wrapped = wrapped;
        this.worldgen = worldgen;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)CoreModule.FRUITIFY.get();
    }

    public int m_214116_(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return this.wrapped.m_214116_(randomSource, i, treeConfiguration);
    }

    public int m_214117_(RandomSource randomSource, int i) {
        return this.wrapped.m_214117_(randomSource, i);
    }

    public boolean m_214203_(RandomSource randomSource, int i, int j, int k, int l, boolean bl) {
        return ((FoliagePlacerAccess)this.wrapped).callShouldSkipLocation(randomSource, i, j, k, l, bl);
    }

    public void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        LinkedHashSet activeLeaves = Sets.newLinkedHashSet();
        FruitifiedFoliageSetter fruitifiedSetter = new FruitifiedFoliageSetter(foliageSetter, activeLeaves, pRandom, this.worldgen);
        ((FoliagePlacerAccess)this.wrapped).callCreateFoliage(level, fruitifiedSetter, pRandom, pConfig, pMaxFreeTreeHeight, pAttachment, pFoliageHeight, pFoliageRadius, pOffset);
        BlockState core = pConfig.f_161213_.m_213972_(pRandom, pAttachment.m_161451_());
        if (core.m_60734_() instanceof FruitLeavesBlock) {
            core = (BlockState)((BlockState)core.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        }
        foliageSetter.m_271838_(pAttachment.m_161451_(), core);
        level.m_141902_(pAttachment.m_161451_(), (BlockEntityType)CoreModule.FRUIT_TREE.get()).ifPresent(be -> {
            be.addActiveLeaves(activeLeaves);
            be.setLifespan(Mth.m_216287_((RandomSource)pRandom, (int)FFCommonConfig.fruitTreeLifespanMin, (int)FFCommonConfig.fruitTreeLifespanMax));
        });
    }

    public static class FruitifiedFoliageSetter
    implements FoliagePlacer.FoliageSetter {
        private final FoliagePlacer.FoliageSetter wrapped;
        private final Set<BlockPos> activeLeaves;
        private final RandomSource random;
        private final boolean worldgen;

        public FruitifiedFoliageSetter(FoliagePlacer.FoliageSetter wrapped, Set<BlockPos> activeLeaves, RandomSource random, boolean worldgen) {
            this.wrapped = wrapped;
            this.activeLeaves = activeLeaves;
            this.random = random;
            this.worldgen = worldgen;
        }

        public void m_271838_(BlockPos blockPos, BlockState blockState) {
            boolean active = true;
            if (blockState.m_61138_((Property)FruitLeavesBlock.AGE)) {
                int i = this.random.m_188503_(4);
                if (i < (this.worldgen ? 3 : 2)) {
                    blockState = (BlockState)blockState.m_61124_((Property)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(0));
                    active = false;
                } else if (this.worldgen && i < 4) {
                    blockState = (BlockState)blockState.m_61124_((Property)FruitLeavesBlock.AGE, (Comparable)Integer.valueOf(2));
                }
            }
            if (active) {
                this.activeLeaves.add(blockPos.m_7949_());
            }
            this.wrapped.m_271838_(blockPos, blockState);
        }

        public boolean m_271808_(BlockPos blockPos) {
            return this.wrapped.m_271808_(blockPos);
        }
    }
}

