/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.food;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.food.FeastBlock;
import snownee.fruits.food.FoodBlock;
import snownee.fruits.food.FoodDispenseBehavior;
import snownee.fruits.food.FoodItem;
import snownee.fruits.food.PieBlock;
import snownee.fruits.util.FoodBuilderExtension;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.VanillaActions;

@KiwiModule(value="food")
@KiwiModule.Optional
@KiwiModule.Category(value={"food"}, after={"pumpkin_pie"})
public class FoodModule
extends AbstractModule {
    public static final TagKey<Item> PANDA_FOOD = FoodModule.itemTag((String)"fruitfulfun", (String)"panda_food");
    public static Item.Properties GRAPEFRUIT_PANNA_COTTA_PROP = FoodModule.itemProp().m_41489_(FoodModule.basicFood(14, 1.0f).effect(Effects.SPEED, 1.0f).build());
    public static final KiwiGO<Block> GRAPEFRUIT_PANNA_COTTA = FoodModule.go(() -> new FoodBlock(Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)4.0, (double)11.5)));
    public static Item.Properties DONAUWELLE_PROP = FoodModule.itemProp().m_41489_(FoodModule.basicFood(14, 1.0f).effect(Effects.REGENERATION, 1.0f).build());
    public static final KiwiGO<Block> DONAUWELLE = FoodModule.go(() -> new FoodBlock(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0)));
    public static Item.Properties HONEY_POMELO_TEA_PROP = FoodModule.itemProp().m_41489_(FoodModule.basicFood(1, Hooks.farmersdelight ? 0.3f : 4.0f).effect(Effects.COMFORT, 1.0f).builder().m_38765_().m_38767_()).m_41495_(Items.f_42590_);
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.TRANSLUCENT)
    public static final KiwiGO<Block> HONEY_POMELO_TEA = FoodModule.go(() -> new FoodBlock(Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.75, (double)11.0)));
    public static Item.Properties RICE_WITH_FRUITS_PROP = FoodModule.itemProp().m_41489_(FoodModule.basicFood(9, 0.6f).effect(Effects.COMFORT, 1.0f).build());
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<Block> RICE_WITH_FRUITS = FoodModule.go(() -> {
        FoodBlock block = new FoodBlock(Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)5.0, (double)14.0));
        block.lockShapeRotation = false;
        return block;
    });
    public static Item.Properties LEMON_ROAST_CHICKEN_PROP = FoodModule.itemProp().m_41495_(Items.f_42399_);
    public static final KiwiGO<Item> LEMON_ROAST_CHICKEN = FoodModule.go(() -> new FoodItem(FoodModule.itemProp().m_41489_(FoodModule.basicFood(16, 0.8f).effect(Effects.NOURISHMENT, 1.0f).build()).m_41495_(Items.f_42399_)));
    public static final KiwiGO<FeastBlock> LEMON_ROAST_CHICKEN_BLOCK = FoodModule.go(() -> new FeastBlock(Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), FeastBlock.LEFTOVER_SHAPE, (Supplier<Item>)LEMON_ROAST_CHICKEN));
    public static final KiwiGO<Item> CHORUS_FRUIT_PIE_SLICE = FoodModule.go(() -> new FoodItem(FoodModule.itemProp().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(0.6f).m_38767_())));
    public static Item.Properties CHORUS_FRUIT_PIE_PROP = FoodModule.itemProp().m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(0.6f).m_38767_());
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<PieBlock> CHORUS_FRUIT_PIE = FoodModule.go(() -> new PieBlock(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), null, (Supplier<Item>)CHORUS_FRUIT_PIE_SLICE));
    public static final KiwiGO<SimpleParticleType> SMOKE = FoodModule.go(() -> new SimpleParticleType(true));

    public FoodModule() {
        Hooks.food = true;
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            Panda.f_29071_ = Panda.f_29071_.or(itemEntity -> {
                ItemStack itemstack = itemEntity.m_32055_();
                return itemEntity.m_6084_() && !itemEntity.m_32063_() && itemstack.m_204117_(PANDA_FOOD);
            });
            KiwiModules.get((ResourceLocation)this.uid).getRegistries((Object)ForgeRegistries.BLOCKS).stream().filter(FoodBlock.class::isInstance).map(Block::m_5456_).filter(Predicate.not(Items.f_41852_::equals)).forEach($ -> DispenserBlock.m_52672_((ItemLike)$, (DispenseItemBehavior)new FoodDispenseBehavior()));
            KiwiModules.get((ResourceLocation)this.uid).getRegistries((Object)ForgeRegistries.ITEMS).stream().filter(Item::m_41472_).forEach($ -> VanillaActions.registerCompostable((float)1.0f, (ItemLike)$));
        });
    }

    private static FoodBuilderExtension basicFood(int nutrition, float saturation) {
        return FoodBuilderExtension.of(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation));
    }

    public static final class Effects {
        private static final Supplier<MobEffectInstance> NOURISHMENT = Effects.make("farmersdelight:nourishment", 6000, 0);
        private static final Supplier<MobEffectInstance> COMFORT = Effects.make("farmersdelight:comfort", 3600, 0);
        private static final Supplier<MobEffectInstance> REGENERATION = Effects.make("regeneration", 120, 0);
        private static final Supplier<MobEffectInstance> SPEED = Effects.make("speed", 1200, 0);

        @Nullable
        private static Supplier<MobEffectInstance> make(String id, int duration, int amplifier) {
            ResourceLocation resourceLocation = new ResourceLocation(id);
            if (!Platform.isModLoaded((String)resourceLocation.m_135827_())) {
                return null;
            }
            return () -> {
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(resourceLocation);
                if (effect == null) {
                    effect = MobEffects.f_216964_;
                }
                return new MobEffectInstance(effect, duration, amplifier);
            };
        }
    }
}

