/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.food;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.food.FoodBlock;
import snownee.fruits.util.CommonProxy;

public class FeastBlock
extends FoodBlock {
    public static final VoxelShape LEFTOVER_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    public final Supplier<Item> servingItem;
    @Nullable
    private final VoxelShape leftoverShape;
    private final int maxServings;

    public FeastBlock(VoxelShape northShape, @Nullable VoxelShape leftoverShape, Supplier<Item> servingItem) {
        super(leftoverShape == null ? northShape : Shapes.m_83110_((VoxelShape)northShape, (VoxelShape)leftoverShape));
        this.leftoverShape = leftoverShape;
        this.servingItem = servingItem;
        int size = this.getServingsProperty().m_6908_().size();
        this.maxServings = this.hasLeftover() ? size - 1 : size;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(this.getMaxServings())));
    }

    public boolean hasLeftover() {
        return this.leftoverShape != null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int serves = this.getServings(state);
        ItemStack servingItem = new ItemStack((ItemLike)this.servingItem.get());
        ItemStack remainder = CommonProxy.getRecipeRemainder(servingItem);
        ItemStack held = player.m_21120_(hand);
        if (serves == 0) {
            this.consumeServing(level, pos, state, player);
        } else if (remainder.m_41619_()) {
            FoodProperties food = servingItem.m_41720_().m_41473_();
            if (food == null || !player.m_36391_(food.m_38747_())) {
                return InteractionResult.PASS;
            }
            this.consumeServing(level, pos, state, player);
            player.m_5584_(level, servingItem);
        } else if (ItemStack.m_41656_((ItemStack)held, (ItemStack)remainder)) {
            if (!level.f_46443_) {
                this.consumeServing(level, pos, state, player);
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                }
                if (!player.m_36356_(servingItem)) {
                    player.m_36176_(servingItem, false);
                }
            }
        } else if (serves == this.getMaxServings() && held.m_41619_()) {
            if (!level.f_46443_) {
                level.m_7471_(pos, false);
                ItemStack blockItem = new ItemStack((ItemLike)this);
                if (!player.m_36356_(blockItem)) {
                    player.m_36176_(blockItem, false);
                }
            }
        } else {
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"tip.fruitfulfun.useContainer", (Object[])new Object[]{remainder.m_41786_()}), true);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void consumeServing(Level level, BlockPos pos, BlockState state, @Nullable Player player) {
        if (!level.f_46443_) {
            int serves = this.getServings(state);
            if (serves > 1 || this.hasLeftover()) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(serves - 1)));
            } else {
                level.m_46953_(pos, true, (Entity)player);
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, this.getServingsProperty()});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getServings(blockState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public IntegerProperty getServingsProperty() {
        return BlockStateProperties.f_222999_;
    }

    public int getMaxServings() {
        return this.maxServings;
    }

    public int getServings(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getServingsProperty());
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.getServings(state) == 0) {
            return LEFTOVER_SHAPE;
        }
        return super.m_5940_(state, level, pos, context);
    }

    @Override
    public BlockItem createItem(Item.Properties builder) {
        return super.createItem(builder.m_41495_(this.servingItem.get().m_41469_()));
    }
}

