/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.compat.jade;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.block.entity.SlidingDoorEntity;
import snownee.fruits.compat.jade.BeeDebugProvider;
import snownee.fruits.compat.jade.CropProgressProvider;
import snownee.fruits.compat.jade.FruitLeavesDebugProvider;
import snownee.fruits.compat.jade.InspectorProvider;
import snownee.fruits.compat.supplementaries.SupplementariesJadeCompat;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IWailaConfig;
import snownee.kiwi.loader.Platform;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    public static final ResourceLocation INSPECTOR = new ResourceLocation("fruitfulfun", "inspector");
    public static final ResourceLocation INSPECTOR_BLOCK = new ResourceLocation("fruitfulfun", "inspector_block");
    public static final ResourceLocation CROP_PROGRESS = new ResourceLocation("fruitfulfun", "crop_progress");

    public static void ensureVisibility(boolean fromEntity) {
        IWailaConfig.IConfigGeneral config = IWailaConfig.get().getGeneral();
        config.setDisplayTooltip(true);
        if (fromEntity) {
            config.setDisplayEntities(true);
        } else {
            config.setDisplayBlocks(true);
        }
    }

    public void register(IWailaCommonRegistration registration) {
        if (!Platform.isProduction()) {
            registration.registerBlockDataProvider((IServerDataProvider)new FruitLeavesDebugProvider(), FruitTreeBlockEntity.class);
            registration.registerEntityDataProvider((IServerDataProvider)new BeeDebugProvider(), Bee.class);
        }
        if (Hooks.bee) {
            registration.registerEntityDataProvider((IServerDataProvider)new InspectorProvider(), Bee.class);
            if (Hooks.supplementaries) {
                SupplementariesJadeCompat.register(registration);
            }
        }
    }

    public void registerClient(IWailaClientRegistration registration) {
        if (!Platform.isProduction()) {
            registration.registerBlockComponent((IBlockComponentProvider)new FruitLeavesDebugProvider(), FruitLeavesBlock.class);
            registration.registerEntityComponent((IEntityComponentProvider)new BeeDebugProvider(), Bee.class);
        }
        registration.registerBlockComponent((IBlockComponentProvider)new CropProgressProvider(), FruitLeavesBlock.class);
        registration.addRayTraceCallback((hit, accessor, original) -> JadeCompat.override(original, registration));
        if (Hooks.bee) {
            registration.registerEntityComponent((IEntityComponentProvider)new InspectorProvider(), Bee.class);
            if (Hooks.supplementaries) {
                SupplementariesJadeCompat.registerClient(registration);
            }
        }
    }

    @Nullable
    private static Accessor<?> override(@Nullable Accessor<?> accessor, IWailaClientRegistration registration) {
        Entity entity;
        if (accessor instanceof EntityAccessor && (entity = ((EntityAccessor)accessor).getEntity()) instanceof SlidingDoorEntity) {
            BlockPos pos = entity.m_20183_();
            Level level = accessor.getLevel();
            BlockHitResult hitResult = new BlockHitResult(accessor.getHitResult().m_82450_(), accessor.getPlayer().m_6350_().m_122424_(), pos, false);
            return registration.blockAccessor().blockState(level.m_8055_(pos)).level(level).player(accessor.getPlayer()).hit(hitResult).build();
        }
        return accessor;
    }
}

