/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.compat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Items;
import snownee.fruits.FruitType;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.InspectorClientHandler;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.Locus;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.compat.jade.JadeCompat;
import snownee.fruits.duck.FFPlayer;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ScaledTextElement;

public class InspectorProvider
implements IEntityComponentProvider,
IBlockComponentProvider,
IServerDataProvider<EntityAccessor> {
    public static void appendServerData(Accessor<?> accessor, Bee bee) {
        ListTag list;
        Set<Trait> traits;
        if (!BeeModule.INSPECTOR.is(accessor.getPlayer().m_21211_())) {
            return;
        }
        CompoundTag data = accessor.getServerData();
        BeeAttributes attributes = BeeAttributes.of(bee);
        List<String> pollens = attributes.getPollens();
        if (!pollens.isEmpty()) {
            ListTag list2 = new ListTag();
            for (String pollen : pollens) {
                list2.add((Object)StringTag.m_129297_((String)pollen));
            }
            data.m_128365_("Pollens", (Tag)list2);
        }
        if (!(traits = attributes.getTraits()).isEmpty()) {
            list = new ListTag();
            for (Trait trait : traits) {
                list.add((Object)StringTag.m_129297_((String)trait.name()));
            }
            data.m_128365_("Traits", (Tag)list);
        }
        list = new ListTag();
        for (Allele allele : Allele.sortedByCode()) {
            CompoundTag tag = new CompoundTag();
            Locus locus = attributes.getLocus(allele);
            tag.m_128359_("Code", String.valueOf(allele.codename));
            tag.m_128405_("High", locus.getHigh());
            tag.m_128405_("Low", locus.getLow());
            list.add((Object)tag);
        }
        data.m_128365_("Loci", (Tag)list);
    }

    public static void appendTooltip(ITooltip tooltip, Accessor<?> accessor) {
        CompoundTag data = accessor.getServerData();
        if (InspectorClientHandler.isAnalyzing()) {
            tooltip.add((Component)Component.m_237115_((String)"tip.fruitfulfun.analyzing"));
            IElementHelper elements = IElementHelper.get();
            IElement icon = elements.smallItem(Items.f_42784_.m_7968_()).message(null);
            int i = InspectorClientHandler.getHoverTicks() / 4 % 3;
            tooltip.append(elements.spacer(2 + i * (int)icon.getCachedSize().f_82470_, (int)icon.getCachedSize().f_82471_));
            tooltip.append(icon);
            tooltip.append(elements.spacer((2 - i) * (int)icon.getCachedSize().f_82470_, (int)icon.getCachedSize().f_82471_));
            return;
        }
        if (!data.m_128441_("Loci")) {
            return;
        }
        tooltip.remove(Identifiers.MC_ENTITY_HEALTH);
        tooltip.remove(Identifiers.MC_ENTITY_ARMOR);
        switch (InspectorClientHandler.getPageNow()) {
            case 0: {
                InspectorProvider.showPollens(tooltip, data);
                break;
            }
            case 1: {
                InspectorProvider.showTraits(tooltip, data);
                break;
            }
            case 2: {
                InspectorProvider.showGenes(tooltip, data, FFPlayer.of(accessor.getPlayer()));
            }
        }
        tooltip.add((IElement)new ScaledTextElement((Component)Component.m_237115_((String)"tip.fruitfulfun.pressAlt").m_130940_(IThemeHelper.get().isLightColorScheme() ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY), 0.75f));
    }

    public static void showPollens(ITooltip tooltip, CompoundTag data) {
        ListTag pollens = data.m_128437_("Pollens", 8);
        InspectorProvider.title(tooltip, "text.fruitfulfun.pollen");
        if (pollens.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"text.fruitfulfun.pollen.none"));
        } else {
            ArrayList elements = Lists.newArrayList();
            for (Tag tag : pollens) {
                elements.add(IElementHelper.get().item(FruitType.getFruitOrDefault(tag.m_7916_()).m_7968_()));
            }
            tooltip.add((List)elements);
        }
    }

    public static void showTraits(ITooltip tooltip, CompoundTag data) {
        ListTag traits = data.m_128437_("Traits", 8);
        InspectorProvider.title(tooltip, "text.fruitfulfun.trait");
        if (traits.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"text.fruitfulfun.trait.none"));
        } else {
            ArrayList strings = Lists.newArrayList();
            for (Tag tag : traits) {
                Trait trait = Trait.REGISTRY.get(tag.m_7916_());
                if (trait == null) continue;
                strings.add(trait.getDisplayName().getString());
            }
            tooltip.add((Component)Component.m_237113_((String)String.join((CharSequence)"/", strings)));
        }
    }

    public static void showGenes(ITooltip tooltip, CompoundTag data, FFPlayer player) {
        InspectorProvider.title(tooltip, "text.fruitfulfun.gene");
        ListTag loci = data.m_128437_("Loci", 10);
        if (loci.isEmpty()) {
            return;
        }
        for (Tag e : loci) {
            CompoundTag tag = (CompoundTag)e;
            String code = tag.m_128461_("Code");
            String name = player.fruits$getGeneName(code);
            String desc = player.fruits$getGeneDesc(code);
            String high = name + (tag.m_128451_("High") + 1);
            String low = name + (tag.m_128451_("Low") + 1);
            if (desc.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"text.fruitfulfun.gene.pair", (Object[])new Object[]{high, low}));
                continue;
            }
            tooltip.add((Component)Component.m_237110_((String)"text.fruitfulfun.gene.pairWithDesc", (Object[])new Object[]{desc, high, low}));
        }
    }

    public static void title(ITooltip tooltip, String key) {
        tooltip.add((IElement)new ScaledTextElement((Component)Component.m_237115_((String)key), 0.75f));
        tooltip.add(IElementHelper.get().spacer(2, 2));
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        InspectorProvider.appendTooltip(tooltip, accessor);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        InspectorProvider.appendTooltip(tooltip, accessor);
    }

    public void appendServerData(CompoundTag data, EntityAccessor accessor) {
        InspectorProvider.appendServerData(accessor, (Bee)accessor.getEntity());
    }

    public ResourceLocation getUid() {
        return JadeCompat.INSPECTOR;
    }

    public int getDefaultPriority() {
        return 5001;
    }
}

