/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.compat.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.compat.jade.JadeCompat;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public class CropProgressProvider
implements IBlockComponentProvider {
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(Identifiers.MC_CROP_PROGRESS)) {
            return;
        }
        BlockState state = accessor.getBlockState();
        if (!((FruitLeavesBlock)state.m_60734_()).canGrow(state)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)FruitLeavesBlock.AGE);
        CropProgressProvider.addMaturityTooltip(tooltip, (float)(age - 1) / 2.0f);
    }

    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.crop_growth", (Object[])new Object[]{IThemeHelper.get().info((Object)String.format("%.0f%%", Float.valueOf(growthValue)))}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.jade.crop_growth", (Object[])new Object[]{IThemeHelper.get().success((Object)Component.m_237115_((String)"tooltip.jade.crop_mature"))}));
        }
    }

    public ResourceLocation getUid() {
        return JadeCompat.CROP_PROGRESS;
    }

    public boolean isRequired() {
        return true;
    }
}

