/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.compat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class BeeDebugProvider
implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor> {
    public static final ResourceLocation UID = new ResourceLocation("fruitfulfun", "bee_debug");

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (Hooks.bee && accessor.getPlayer().m_21055_((Item)BeeModule.INSPECTOR.get())) {
            return;
        }
        CompoundTag data = accessor.getServerData();
        if (data.m_128471_("Trusted")) {
            tooltip.add((Component)Component.m_237113_((String)"Trusted"));
        }
        BeeAttributes attributes = new BeeAttributes();
        attributes.fromNBT(data.m_128469_("BeeAttributes"), (Bee)accessor.getEntity());
        ArrayList genes = Lists.newArrayList();
        attributes.getLoci().forEach((allele, locus) -> {
            genes.add(allele.getDisplayName(locus.getHigh()).getString());
            genes.add(allele.getDisplayName(locus.getLow()).getString());
        });
        tooltip.add((Component)Component.m_237113_((String)String.join((CharSequence)" ", genes)));
        ArrayList traits = Lists.newArrayList();
        attributes.getTraits().forEach(trait -> traits.add(trait.name()));
        if (!traits.isEmpty()) {
            traits.sort(String::compareTo);
            tooltip.add((Component)Component.m_237113_((String)String.join((CharSequence)" ", traits)));
        }
    }

    public void appendServerData(CompoundTag data, EntityAccessor accessor) {
        Bee bee = (Bee)accessor.getEntity();
        BeeAttributes attributes = BeeAttributes.of(bee);
        data.m_128379_("Trusted", attributes.trusts(accessor.getPlayer().m_20148_()));
        CompoundTag tag = new CompoundTag();
        attributes.toNBT(tag);
        data.m_128365_("BeeAttributes", (Tag)tag);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public boolean isRequired() {
        return true;
    }
}

