/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.client.particle;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PetalParticle
extends TextureSheetParticle {
    private final float rollStepX;
    private final float rollStepZ;
    private float rollX;
    private float oRollX;
    private boolean inWater;
    private final float particleRandom;
    private int sinceNotInWater;

    private PetalParticle(ClientLevel world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.f_107225_ = 300;
        this.particleRandom = this.f_107223_.m_188501_();
        this.f_107224_ = this.f_107223_.m_188503_(20);
        this.f_107663_ = 0.75f + this.f_107223_.m_188501_() * 0.25f;
        this.f_107230_ = 0.7f + this.f_107223_.m_188501_() * 0.3f;
        this.f_107226_ = 7.5E-4f;
        float baseMotionX = 0.5f + this.f_107223_.m_188501_() * 0.2f;
        float baseMotionY = -0.75f;
        float baseMotionZ = 0.5f + this.f_107223_.m_188501_() * 0.2f;
        if (this.f_107223_.m_188501_() < 0.2f) {
            float f = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
            baseMotionX += Mth.m_14031_((float)f) * 0.3f;
            baseMotionZ += Mth.m_14089_((float)f) * 0.3f;
        }
        Vector3f motion = new Vector3f(baseMotionX, baseMotionY, baseMotionZ);
        motion.normalize().mul(0.03f + this.f_107223_.m_188501_() * 0.005f);
        this.f_107215_ = motion.x();
        this.f_107216_ = motion.y();
        this.f_107217_ = motion.z();
        if (this.f_107223_.m_188501_() < 0.2f) {
            this.f_107216_ -= (double)(this.f_107223_.m_188501_() * 0.02f);
        }
        this.rollStepX = 0.1f + this.f_107223_.m_188501_() * 0.1f * (float)(this.f_107223_.m_188499_() ? 1 : -1);
        this.rollStepZ = 0.1f + this.f_107223_.m_188501_() * 0.1f * (float)(this.f_107223_.m_188499_() ? 1 : -1);
        this.f_107228_ = this.f_107229_ = this.f_107223_.m_188501_() * 0.3f + 0.7f;
        this.f_107227_ = this.f_107229_;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public float m_5902_(float pTicks) {
        if (this.f_107225_ - this.f_107224_ < 10) {
            float f = Mth.m_14031_((float)((float)((double)(((float)(this.f_107225_ - this.f_107224_) - pTicks) / 20.0f) * Math.PI)));
            return Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        this.oRollX = this.rollX;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        boolean lastOnGround = this.f_107218_;
        if (!this.f_107218_ && !this.inWater) {
            double time = (double)this.f_107224_ * (0.1 + (double)this.particleRandom * 0.03);
            double e = Math.sin(time) * 0.0025;
            this.f_107216_ -= e;
            if (this.f_107216_ > 0.0) {
                this.f_107216_ = 0.0;
                this.f_107215_ += Math.sin(this.particleRandom * ((float)Math.PI * 2)) * 5.0E-4;
                this.f_107217_ += Math.cos(this.particleRandom * ((float)Math.PI * 2)) * 5.0E-4;
            }
            time = (double)(this.f_107224_ + 3) * (0.1 + (double)this.particleRandom * 0.03);
            double d = Math.sin(time) * 0.0025;
            this.f_107215_ += d;
            this.f_107217_ += d;
            this.f_107231_ += this.rollStepZ;
            this.rollX += this.rollStepX;
        }
        if (this.sinceNotInWater > 0) {
            ++this.sinceNotInWater;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107218_) {
            if (!lastOnGround) {
                this.f_107224_ = this.f_107225_ - 20;
            }
            this.f_107215_ *= 0.5;
            this.f_107217_ *= 0.5;
        } else if (this.inWater) {
            this.f_107215_ *= 0.66;
            this.f_107217_ *= 0.66;
        } else {
            if (lastOnGround) {
                this.f_107224_ = this.f_107225_ - 60;
            }
            this.f_107216_ *= 0.998;
            if (Math.abs(this.f_107215_) > 0.3) {
                this.f_107215_ *= 0.85;
            }
            if (Math.abs(this.f_107216_) > 0.3) {
                this.f_107216_ *= 0.85;
            }
            if (Math.abs(this.f_107217_) > 0.3) {
                this.f_107217_ *= 0.85;
            }
        }
    }

    public void m_6257_(double pX, double pY, double pZ) {
        BlockPos pos = BlockPos.m_274561_((double)(this.f_107212_ + pX), (double)(this.f_107213_ + pY), (double)(this.f_107214_ + pZ));
        FluidState fluidState = this.f_107208_.m_6425_(pos);
        float waterHeight = fluidState.m_76155_((BlockGetter)this.f_107208_, pos) + (float)pos.m_123342_();
        boolean oInWater = this.inWater;
        boolean bl = this.inWater = (oInWater || this.f_107213_ <= (double)waterHeight) && fluidState.m_205070_(FluidTags.f_13131_);
        if (this.inWater) {
            this.sinceNotInWater = 0;
            Vec3 flow = fluidState.m_76179_((BlockGetter)this.f_107208_, pos);
            pX = flow.f_82479_ * 0.05;
            pY = flow.f_82480_ * 0.05 - 0.05;
            pZ = flow.f_82481_ * 0.05;
        } else if (oInWater) {
            this.sinceNotInWater = 1;
        }
        double lastX = pX;
        double lastY = pY;
        double lastZ = pZ;
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            Vec3 moveVec = PetalParticle.collideBoundingBox(new Vec3(pX, pY, pZ), this.m_107277_(), (Level)this.f_107208_);
            pX = moveVec.f_82479_;
            pY = moveVec.f_82480_;
            pZ = moveVec.f_82481_;
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            if (this.inWater) {
                pY = (double)this.accurateWaterHeight(pos, waterHeight) - this.f_107213_;
            }
            this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
            this.m_107275_();
        }
        if (Math.abs(lastY) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
            this.f_107205_ = true;
        }
        if (!this.inWater) {
            boolean bl2 = this.f_107218_ = lastY != pY && lastY < 0.0;
            if (lastX != pX) {
                this.f_107215_ *= -0.5;
            }
            if (lastZ != pZ) {
                this.f_107217_ *= -0.5;
            }
        }
    }

    private float accurateWaterHeight(BlockPos pos, float waterHeight) {
        if (((Boolean)this.f_107208_.m_6425_(pos).m_61143_((Property)FlowingFluid.f_75947_)).booleanValue()) {
            waterHeight = pos.m_123342_();
        }
        float highest = waterHeight;
        Direction highestSide = null;
        for (Direction side : Direction.Plane.HORIZONTAL) {
            BlockPos sidePos = pos.m_121945_(side);
            float sideHeight = this.getWaterHeight(sidePos, waterHeight);
            if (!(sideHeight > highest)) continue;
            highest = sideHeight;
            highestSide = side;
        }
        if (highestSide != null) {
            float ratio;
            float f = ratio = highestSide.m_122434_() == Direction.Axis.X ? (float)(this.f_107212_ - (double)pos.m_123341_()) : (float)(this.f_107214_ - (double)pos.m_123343_());
            if (highestSide.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                ratio = 1.0f - ratio;
            }
            return Mth.m_14179_((float)ratio, (float)waterHeight, (float)highest);
        }
        return waterHeight;
    }

    private float getWaterHeight(BlockPos pos, float waterHeight) {
        FluidState fluidState = this.f_107208_.m_6425_(pos);
        if (fluidState.m_205070_(FluidTags.f_13131_)) {
            return fluidState.m_76155_((BlockGetter)this.f_107208_, pos) + (float)pos.m_123342_();
        }
        return waterHeight;
    }

    public static Vec3 collideBoundingBox(Vec3 vec3, AABB aABB, Level level) {
        BlockCollisions iterator = new BlockCollisions((CollisionGetter)level, null, aABB.m_82369_(vec3), true, (mutableBlockPos, voxelShape) -> voxelShape);
        return Entity.m_198900_((Vec3)vec3, (AABB)aABB, (List)ImmutableList.copyOf((Iterator)iterator));
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Quaternionf quaternion;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        Vector3f sub = new Vector3f(f, f1, f2);
        float rollZ = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
        if (this.f_107218_ || this.inWater || this.sinceNotInWater > 0 && this.sinceNotInWater < 5) {
            quaternion = Axis.f_252529_.m_252977_(90.0f);
            f1 += 0.005f + rollZ % 0.01f;
        } else {
            quaternion = new Quaternionf();
            float rollX = Mth.m_14179_((float)partialTicks, (float)this.oRollX, (float)this.rollX);
            quaternion.rotateX(rollX);
            quaternion.rotateY(rollX * 0.2f);
        }
        quaternion.rotateZ(rollZ);
        Vector3f quadNormal = new Vector3f(0.0f, 0.0f, 1.0f);
        quadNormal.rotate((Quaternionfc)quaternion);
        Vector3f[] vertex = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float[] uv = new float[]{this.m_5970_(), this.m_5951_(), this.m_5952_(), this.m_5950_()};
        if (sub.dot((Vector3fc)quadNormal) < 0.0f) {
            for (int i = 0; i < 4; ++i) {
                vertex[i].mul(-1.0f, 1.0f, 1.0f);
            }
            uv[0] = this.m_5952_();
            uv[2] = this.m_5970_();
        }
        float f4 = this.m_5902_(partialTicks);
        float alpha = f4 * this.f_107230_;
        f4 *= this.f_107663_ * 0.15f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vertex[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        int j = this.m_6355_(partialTicks);
        buffer.m_5483_((double)vertex[0].x(), (double)vertex[0].y(), (double)vertex[0].z()).m_7421_(uv[2], uv[3]).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)vertex[1].x(), (double)vertex[1].y(), (double)vertex[1].z()).m_7421_(uv[2], uv[1]).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)vertex[2].x(), (double)vertex[2].y(), (double)vertex[2].z()).m_7421_(uv[0], uv[1]).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)vertex[3].x(), (double)vertex[3].y(), (double)vertex[3].z()).m_7421_(uv[0], uv[3]).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PetalParticle particle = new PetalParticle(worldIn, x, y, z);
            particle.m_108335_(this.spriteSet);
            particle.f_107215_ += xSpeed;
            particle.f_107216_ += ySpeed;
            particle.f_107217_ += zSpeed;
            if (Math.abs(xSpeed) > 0.5 || Math.abs(ySpeed) > 0.5 || Math.abs(zSpeed) > 0.5) {
                particle.f_107225_ = 60;
            }
            return particle;
        }
    }
}

