/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.cherry.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import snownee.fruits.FFClientConfig;
import snownee.fruits.cherry.CherryModule;
import snownee.fruits.util.CommonProxy;
import snownee.kiwi.item.ModItem;

public class FlowerCrownItem
extends ModItem
implements Equipable {
    private final ParticleOptions particle;

    public FlowerCrownItem(Item.Properties builder, ParticleOptions particle) {
        super(builder.m_41487_(1));
        this.particle = particle;
    }

    public static void spawnParticles(LivingEntity entity) {
        if (entity.m_5842_() || entity.m_20077_()) {
            return;
        }
        int i = 50;
        if (entity.m_21255_() || entity.f_19789_ > 3.0f) {
            i = 3;
        } else if (entity.m_20142_()) {
            i = 10;
        }
        RandomSource random = entity.m_217043_();
        if (random.m_188503_(i) != 0) {
            return;
        }
        FlowerCrownItem item = CommonProxy.getFlowerCrown(entity);
        if (item == null) {
            return;
        }
        Vec3 eye = entity.m_146892_();
        Vec3 lookAngle = entity.m_20154_();
        double x = eye.m_7096_() + random.m_188500_() * 0.4 - 0.2 - lookAngle.m_7096_() * 0.2;
        double y = eye.m_7098_() + 0.2;
        double z = eye.m_7094_() + random.m_188500_() * 0.4 - 0.2 - lookAngle.m_7094_() * 0.2;
        Vec3 deltaMovement = entity.m_20184_();
        double motionX = deltaMovement.m_7096_() - lookAngle.m_7096_() * 0.03;
        double motionY = deltaMovement.m_7098_() - lookAngle.m_7098_() * 0.03;
        double motionZ = deltaMovement.m_7094_() - lookAngle.m_7094_() * 0.03;
        entity.m_9236_().m_7106_(item.getParticle(), x, y, z, motionX, motionY, motionZ);
    }

    @NotNull
    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    @NotNull
    public SoundEvent m_150681_() {
        return (SoundEvent)CherryModule.EQUIP_CROWN.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return this.m_269277_((Item)this, level, player, interactionHand);
    }

    public ParticleOptions getParticle() {
        if (FFClientConfig.cherryParticle == FFClientConfig.CherryParticleOption.Vanilla && CherryModule.CHERRY_CROWN.is((Object)this)) {
            return ParticleTypes.f_276452_;
        }
        return this.particle;
    }
}

