/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.cherry.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import snownee.fruits.FFClientConfig;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.cherry.CherryModule;

public class CherryLeavesBlock
extends FruitLeavesBlock {
    protected final ParticleOptions particleType;

    public CherryLeavesBlock(Supplier<FruitType> type, BlockBehaviour.Properties properties, ParticleOptions particleType) {
        super(type, properties);
        this.particleType = particleType;
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (FFClientConfig.cherryParticle == FFClientConfig.CherryParticleOption.Disabled) {
            return;
        }
        if (FFClientConfig.cherryParticle == FFClientConfig.CherryParticleOption.Vanilla && CherryModule.CHERRY_LEAVES.is((Object)this)) {
            Blocks.f_271115_.m_214162_(stateIn, level, pos, rand);
            return;
        }
        int i = rand.m_188503_(64 - FFClientConfig.moddedCherryParticleFrequency);
        if (i > 1) {
            return;
        }
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP)) {
            return;
        }
        boolean raining = level.m_46758_(pos.m_7494_());
        if (raining && i == 0) {
            double d0 = (float)pos.m_123341_() + rand.m_188501_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (float)pos.m_123343_() + rand.m_188501_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        } else if (i == 1) {
            double d0 = (float)pos.m_123341_() + rand.m_188501_();
            double d1 = (float)pos.m_123342_() + rand.m_188501_();
            double d2 = (float)pos.m_123343_() + rand.m_188501_();
            level.m_7106_(this.particleType, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState blockState) {
        super.m_142387_(level, player, pos, blockState);
        CherryLeavesBlock.spawnDestroyParticles(level, player, pos, this.particleType);
    }

    public static void spawnDestroyParticles(Level level, Player player, BlockPos pos, ParticleOptions particleType) {
        if (level.f_46443_ && FFClientConfig.cherryParticle == FFClientConfig.CherryParticleOption.Modded && pos.m_203193_((Position)player.m_20182_()) < 81.0) {
            int times = Mth.m_216287_((RandomSource)level.f_46441_, (int)6, (int)12);
            for (int i = 0; i < times; ++i) {
                double x = level.f_46441_.m_188583_() * 0.3;
                double y = level.f_46441_.m_188583_() * 0.3;
                double z = level.f_46441_.m_188583_() * 0.3;
                level.m_7106_(particleType, x += (double)pos.m_123341_() + 0.5, y += (double)pos.m_123342_() + 0.5, z += (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }
}

