/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.block.entity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.fruits.CoreFruitTypes;
import snownee.fruits.CoreModule;
import snownee.fruits.FFRegistries;
import snownee.fruits.FruitType;
import snownee.kiwi.block.entity.ModBlockEntity;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.Util;

public class FruitTreeBlockEntity
extends ModBlockEntity {
    public FruitType type = (FruitType)CoreFruitTypes.CITRON.get();
    private int lifespan = 20;
    private ItemEntity onlyItem;
    private final Set<BlockPos> activeLeaves = Sets.newLinkedHashSet();

    public FruitTreeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CoreModule.FRUIT_TREE.get(), pos, state);
    }

    public FruitTreeBlockEntity(BlockPos pos, BlockState state, FruitType type) {
        this(pos, state);
        this.type = type;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return null;
    }

    protected void readPacketData(CompoundTag data) {
    }

    protected CompoundTag writePacketData(CompoundTag data) {
        return data;
    }

    public void m_142466_(CompoundTag compound) {
        NBTHelper helper = NBTHelper.of((CompoundTag)compound);
        String id = helper.getString("Type");
        if (id != null) {
            this.type = (FruitType)FFRegistries.FRUIT_TYPE.m_7745_(Util.RL((String)id, (String)"fruitfulfun"));
        }
        this.lifespan = helper.getInt("Lifespan");
        ListTag list = helper.getTagList("ActiveLeaves", 10);
        if (list != null) {
            for (Tag tag : list) {
                this.activeLeaves.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag)));
            }
        }
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128359_("Type", Util.trimRL((ResourceLocation)FFRegistries.FRUIT_TYPE.m_7981_((Object)this.type), (String)"fruitfulfun"));
        compound.m_128405_("Lifespan", this.lifespan);
        if (!this.activeLeaves.isEmpty()) {
            ListTag list = new ListTag();
            for (BlockPos pos : this.activeLeaves) {
                list.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            compound.m_128365_("ActiveLeaves", (Tag)list);
        }
        super.m_183515_(compound);
    }

    public boolean canDrop() {
        return this.onlyItem == null || !this.onlyItem.m_6084_();
    }

    public void setOnlyItem(ItemEntity itementity) {
        this.onlyItem = itementity;
    }

    public void addActiveLeaves(Collection<BlockPos> leaves) {
        for (BlockPos pos : leaves) {
            pos = pos.m_121996_((Vec3i)this.f_58858_);
            this.activeLeaves.add(pos);
        }
    }

    public void removeActiveLeaves(BlockPos pos) {
        pos = pos.m_121996_((Vec3i)this.f_58858_);
        this.activeLeaves.remove(pos);
    }

    public Set<BlockPos> getActiveLeaves() {
        return this.activeLeaves;
    }

    public void consumeLifespan(int i) {
        this.lifespan -= i;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public boolean isDead() {
        return this.lifespan <= 0;
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
    }
}

