/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.block;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.CoreModule;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.FruitType;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.util.CommonProxy;
import snownee.kiwi.KiwiModule;

@KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
public class FruitLeavesBlock
extends LeavesBlock
implements BonemealableBlock,
EntityBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public final Supplier<FruitType> type;

    public FruitLeavesBlock(Supplier<FruitType> type, BlockBehaviour.Properties properties) {
        super(properties.m_60922_(Blocks::m_50821_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_60924_(Blocks::m_50805_));
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public static ItemEntity dropFruit(ServerLevel level, BlockPos pos, BlockState state, @Nullable FruitTreeBlockEntity core, int consumeLifespan) {
        if ((Integer)state.m_61143_((Property)AGE) != 3) {
            return null;
        }
        if (!level.m_46469_().m_46207_(GameRules.f_46136_)) {
            return null;
        }
        boolean die = true;
        if (core != null) {
            core.consumeLifespan(consumeLifespan);
            die = core.isDead();
            if (die) {
                core.removeActiveLeaves(pos);
            }
        }
        state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(die ? 0 : 1));
        if (die && state.m_155947_()) {
            state = (BlockState)state.m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false));
        }
        level.m_46597_(pos, state);
        ItemEntity itemEntity = ((FruitLeavesBlock)state.m_60734_()).doDropFruit(level, pos, state, core, consumeLifespan);
        if (itemEntity != null && !level.m_7967_((Entity)itemEntity)) {
            return null;
        }
        return itemEntity;
    }

    @Nullable
    public ItemEntity doDropFruit(ServerLevel level, BlockPos pos, BlockState state, @Nullable FruitTreeBlockEntity core, int consumeLifespan) {
        return FruitLeavesBlock.createItemEntity(level, pos, this.type.get().fruit.get().m_7968_());
    }

    public static ItemEntity createItemEntity(ServerLevel level, BlockPos pos, ItemStack stack) {
        float f = EntityType.f_20461_.m_20679_() / 2.0f;
        double d0 = (double)((float)pos.m_123341_() + 0.5f) + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.25, (double)0.25);
        double d1 = (double)((float)pos.m_123342_() + 0.5f) + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.25, (double)0.25) - (double)f;
        double d2 = (double)((float)pos.m_123343_() + 0.5f) + Mth.m_216263_((RandomSource)level.f_46441_, (double)-0.25, (double)0.25);
        ItemEntity itemEntity = new ItemEntity((Level)level, d0, d1, d2, stack);
        itemEntity.m_32060_();
        return itemEntity;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54418_, f_54419_, AGE, f_221367_});
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        if ((Integer)state.m_61143_((Property)AGE) == 1) {
            return true;
        }
        return this.canGrow(state) && (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        world.m_46597_(pos, (BlockState)state.m_61122_((Property)AGE));
    }

    @Nullable
    public FruitTreeBlockEntity findCore(ServerLevel level, BlockPos pos) {
        return level.m_8904_().m_27192_(this.type.get().poiType::equals, pos, 10, PoiManager.Occupancy.ANY).flatMap(core -> level.m_141902_(core, (BlockEntityType)CoreModule.FRUIT_TREE.get())).orElse(null);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (this.shouldDecay(state)) {
            FruitLeavesBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            world.m_7471_(pos, false);
        } else if (this.canGrow(state) && world.m_46803_(pos.m_7494_()) >= 9) {
            if (this.hasFruit(state, (Level)world, pos)) {
                FFCommonConfig.DropMode mode = FFCommonConfig.getDropMode((LevelAccessor)world);
                if (mode == FFCommonConfig.DropMode.NoDrop) {
                    return;
                }
                FruitTreeBlockEntity core = this.findCore(world, pos);
                if (mode == FFCommonConfig.DropMode.OneByOne && core != null && !core.canDrop()) {
                    return;
                }
                ItemEntity itemEntity = FruitLeavesBlock.dropFruit(world, pos, state, core, 1);
                if (mode == FFCommonConfig.DropMode.OneByOne && core != null && itemEntity != null) {
                    core.setOnlyItem(itemEntity);
                }
            } else {
                boolean def = rand.m_188503_(100) > 99 - FFCommonConfig.treeGrowingSpeed;
                CommonProxy.maybeGrowCrops(world, pos, state, def, () -> this.m_214148_(world, rand, pos, state));
            }
        }
    }

    public boolean hasFruit(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)AGE) == 3;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (((Boolean)(state = FruitLeavesBlock.m_54435_((BlockState)state, (LevelAccessor)world, (BlockPos)pos)).m_61143_((Property)f_54419_)).booleanValue() && (Integer)state.m_61143_((Property)f_54418_) != 1) {
            state = (BlockState)state.m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false));
        }
        world.m_46597_(pos, state);
    }

    public boolean m_6724_(BlockState state) {
        return this.notPlacedByPlayer(state);
    }

    public boolean notPlacedByPlayer(BlockState state) {
        return this.shouldDecay(state) || this.canGrow(state) || (Integer)state.m_61143_((Property)AGE) == 0;
    }

    public boolean shouldDecay(BlockState state) {
        return (Integer)state.m_61143_((Property)f_54418_) == 7 && (Boolean)state.m_61143_((Property)f_54419_) == false;
    }

    public boolean canGrow(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) > 0 && ((Boolean)state.m_61143_((Property)f_54419_) == false || (Integer)state.m_61143_((Property)f_54418_) == 1);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.canGrow(state) || (Integer)state.m_61143_((Property)AGE) == 0) {
            return super.m_7417_(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Entity entity;
        EntityCollisionContext c;
        if (context instanceof EntityCollisionContext && (c = (EntityCollisionContext)context).m_193113_() != null && ((entity = c.m_193113_()) instanceof ItemEntity || entity instanceof FlyingAnimal)) {
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public void m_142072_(Level worldIn, BlockState stateIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, stateIn, pos, entityIn, fallDistance);
        if (fallDistance >= 1.0f && worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (entityIn instanceof LivingEntity || entityIn instanceof FallingBlockEntity) {
                Iterable posList = BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -2, -1), (BlockPos)pos.m_7918_(1, 0, 1));
                MutableBoolean success = new MutableBoolean(false);
                FruitLeavesBlock.rangeDrop(serverLevel, posList, 2, null, itemEntity -> success.setTrue());
                if (success.booleanValue()) {
                    // empty if block
                }
            }
        }
    }

    public static void rangeDrop(ServerLevel level, Iterable<BlockPos> posList, int consumeLifespan, @Nullable FruitTreeBlockEntity core, @Nullable Consumer<ItemEntity> consumer) {
        for (BlockPos blockpos : posList) {
            BlockState state = level.m_8055_(blockpos);
            Block block = state.m_60734_();
            if (!(block instanceof FruitLeavesBlock)) continue;
            FruitLeavesBlock leavesBlock = (FruitLeavesBlock)block;
            if ((Integer)state.m_61143_((Property)AGE) != 3) continue;
            ItemEntity itemEntity = FruitLeavesBlock.dropFruit(level, blockpos, state, core == null ? leavesBlock.findCore(level, blockpos) : core, consumeLifespan);
            if (consumer == null || itemEntity == null) continue;
            consumer.accept(itemEntity);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult ray) {
        if (this.hasFruit(state, worldIn, pos) && worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)))) {
            FruitLeavesBlock.giveItemTo(playerIn, ray, this.type.get().fruit.get().m_7968_());
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static void giveItemTo(Player player, BlockHitResult hit, ItemStack stack) {
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!CommonProxy.isFakePlayer((Entity)player) && player.m_36356_(stack)) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, player.m_5720_(), 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        } else {
            FruitLeavesBlock.m_152435_((Level)level, (BlockPos)hit.m_82425_(), (Direction)hit.m_82434_(), (ItemStack)stack);
        }
    }

    public boolean hasBlockEntity(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) != false && (Integer)state.m_61143_((Property)f_54418_) == 1;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState state) {
        if (this.hasBlockEntity(state)) {
            return new FruitTreeBlockEntity(pPos, state, this.type.get());
        }
        return null;
    }
}

