/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.network;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.genetics.Trait;
import snownee.kiwi.network.KPacketTarget;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;

@KiwiPacket(value="sync_bee", dir=KiwiPacket.Direction.PLAY_TO_CLIENT)
public class SSyncBeePacket
extends PacketHandler {
    public static SSyncBeePacket I;

    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> executor, FriendlyByteBuf buf, @Nullable ServerPlayer serverPlayer) {
        int id = buf.m_130242_();
        ItemStack saddle = buf.m_130267_();
        List trusted = buf.m_236845_(FriendlyByteBuf::m_130259_);
        String texture = buf.m_130277_();
        List traits = buf.m_236845_(FriendlyByteBuf::m_130277_);
        long mutagenEndsIn = buf.readLong();
        return executor.apply(() -> {
            Entity entity = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_6815_(id);
            if (entity instanceof Bee) {
                BeeAttributes attributes = BeeAttributes.of(entity);
                attributes.setSaddle(saddle);
                attributes.setTrusted(trusted);
                if (texture.isEmpty()) {
                    attributes.setTexture(null);
                } else {
                    attributes.setTexture(ResourceLocation.m_135820_((String)texture));
                }
                attributes.setTraits(traits.stream().map(Trait.REGISTRY::get).filter(Objects::nonNull).toList());
                attributes.setMutagenEndsIn(mutagenEndsIn, entity.m_9236_().m_46467_());
            }
        });
    }

    public static void send(Bee bee) {
        I.send(KPacketTarget.tracking((Entity)bee), SSyncBeePacket.putData(bee));
    }

    public static void send(Bee bee, ServerPlayer player) {
        I.send(player, SSyncBeePacket.putData(bee));
    }

    private static Consumer<FriendlyByteBuf> putData(Bee bee) {
        BeeAttributes attributes = BeeAttributes.of(bee);
        return buf -> {
            buf.m_130130_(bee.m_19879_());
            buf.m_130055_(attributes.getSaddle());
            buf.m_236828_(attributes.getTrusted(), FriendlyByteBuf::m_130077_);
            ResourceLocation texture = attributes.getTexture();
            buf.m_130070_(texture == null ? "" : texture.toString());
            buf.m_236828_(attributes.getTraits().stream().map(Trait::name).toList(), FriendlyByteBuf::m_130070_);
            buf.writeLong(attributes.getMutagenEndsIn());
        };
    }
}

