/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.network;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.InspectorClientHandler;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.Locus;
import snownee.fruits.bee.genetics.Trait;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;

@KiwiPacket(value="inspect_bee_reply", dir=KiwiPacket.Direction.PLAY_TO_CLIENT)
public class SInspectBeeReplyPacket
extends PacketHandler {
    public static SInspectBeeReplyPacket I;

    public static void send(ServerPlayer player, BeeAttributes attributes) {
        I.send(player, (T buf0) -> {
            buf0.m_236828_(attributes.getTraits().stream().map(Trait::name).toList(), FriendlyByteBuf::m_130070_);
            buf0.m_236828_(attributes.getPollens(), FriendlyByteBuf::m_130070_);
            buf0.m_130130_(Allele.sortedByCode().size());
            for (Allele allele : Allele.sortedByCode()) {
                Locus locus = attributes.getLocus(allele);
                buf0.writeChar((int)allele.codename);
                buf0.m_130130_(locus.getHigh());
                buf0.m_130130_(locus.getLow());
            }
        });
    }

    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> executor, FriendlyByteBuf buf, @Nullable ServerPlayer player) {
        List traits = buf.m_236845_(FriendlyByteBuf::m_130277_);
        List pollens = buf.m_236845_(FriendlyByteBuf::m_130277_);
        List genes = buf.m_236845_($ -> new GeneRecord($.readChar(), $.m_130242_() + 1, $.m_130242_() + 1));
        return executor.apply(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            List<Trait> realTraits = traits.stream().sorted().map(Trait.REGISTRY::get).filter(Objects::nonNull).toList();
            InspectorClientHandler.writeToBook(mc.f_91074_, realTraits, pollens, genes);
        });
    }

    public record GeneRecord(char code, int high, int low) {
    }
}

