/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.compat.supplementaries.SupplementariesCompat;

public interface InspectTarget {
    @Nullable
    public static InspectTarget find(@Nullable Level level, @Nullable HitResult hitResult) {
        Entity entity;
        BlockPos pos;
        BlockEntity be;
        if (hitResult == null || level == null) {
            return null;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity2 = ((EntityHitResult)hitResult).m_82443_();
            if (entity2 instanceof Bee) {
                Bee bee = (Bee)entity2;
                return EntityTarget.of((Entity)bee);
            }
        } else if (hitResult.m_6662_() == HitResult.Type.BLOCK && (be = level.m_7702_(pos = ((BlockHitResult)hitResult).m_82425_())) != null && Hooks.supplementaries && (entity = SupplementariesCompat.getTargetEntity(be)) instanceof Bee) {
            return BlockTarget.of(level, pos);
        }
        return null;
    }

    public static InspectTarget fromNetwork(FriendlyByteBuf buf) {
        int i = buf.m_130242_();
        if (i == 0) {
            return new EntityTarget((ResourceKey<Level>)buf.m_236801_(Registries.f_256858_), buf.m_130242_());
        }
        if (i == 1) {
            return new BlockTarget((ResourceKey<Level>)buf.m_236801_(Registries.f_256858_), buf.m_130135_());
        }
        return null;
    }

    public Entity getEntity(Level var1);

    public void toNetwork(FriendlyByteBuf var1);

    public record EntityTarget(ResourceKey<Level> dimension, int id) implements InspectTarget
    {
        public static EntityTarget of(Entity entity) {
            return new EntityTarget((ResourceKey<Level>)entity.m_9236_().m_46472_(), entity.m_19879_());
        }

        @Override
        public Entity getEntity(Level level) {
            if (level.m_46472_() != this.dimension) {
                return null;
            }
            return level.m_6815_(this.id);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130130_(0);
            buf.m_236858_(this.dimension);
            buf.m_130130_(this.id);
        }
    }

    public record BlockTarget(ResourceKey<Level> dimension, BlockPos pos) implements InspectTarget
    {
        public static BlockTarget of(Level level, BlockPos pos) {
            return new BlockTarget((ResourceKey<Level>)level.m_46472_(), pos);
        }

        @Override
        public Entity getEntity(Level level) {
            if (level.m_46472_() != this.dimension) {
                return null;
            }
            BlockEntity be = level.m_7702_(this.pos);
            if (be == null) {
                return null;
            }
            if (Hooks.supplementaries) {
                return SupplementariesCompat.getTargetEntity(be);
            }
            return null;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130130_(1);
            buf.m_236858_(this.dimension);
            buf.m_130064_(this.pos);
        }
    }
}

