/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.network;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.network.InspectTarget;
import snownee.fruits.bee.network.SInspectBeeReplyPacket;
import snownee.fruits.duck.FFPlayer;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;

@KiwiPacket(value="inspect_bee", dir=KiwiPacket.Direction.PLAY_TO_SERVER)
public class CInspectBeePacket
extends PacketHandler {
    public static CInspectBeePacket I;

    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> executor, FriendlyByteBuf buf, @Nullable ServerPlayer player) {
        Objects.requireNonNull(player);
        InspectTarget target = InspectTarget.fromNetwork(buf);
        if (target == null) {
            return null;
        }
        return executor.apply(() -> {
            Entity entity = target.getEntity(player.m_9236_());
            FFPlayer.of(player).fruits$maybeInitGenes();
            if (entity instanceof Bee) {
                Bee bee = (Bee)entity;
                Advancement advancement = Hooks.advancement((ServerLevel)player.m_9236_(), "inspector");
                if (advancement != null) {
                    player.m_8960_().m_135988_(advancement, "_");
                }
                SInspectBeeReplyPacket.send(player, BeeAttributes.of(bee));
            }
        });
    }
}

