/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.genetics;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.duck.FFPlayer;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.Platform;

public class MutagenItem
extends ModItem {
    public static final Item BREWING_ITEM = Items.f_276698_;
    public static final RandomSource RANDOM = RandomSource.m_216327_();

    public MutagenItem() {
        super(new Item.Properties());
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        return MutagenItem.getCodename(stack).map(MutagenItem::getClientName).map(s -> Component.m_237110_((String)"item.fruitfulfun.mutagen.stable", (Object[])new Object[]{s})).orElseGet(() -> {
            if (this.isImperfect(stack)) {
                return Component.m_237115_((String)"item.fruitfulfun.mutagen.imperfect");
            }
            return super.m_7626_(stack);
        });
    }

    public ItemStack m_7968_() {
        return this.imperfectMutagen();
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        Bee bee;
        if (!(entity instanceof Bee) || (bee = (Bee)entity).m_6162_()) {
            return InteractionResult.PASS;
        }
        if (BeeAttributes.of(bee).getMutagenEndsIn() > player.m_9236_().m_46467_()) {
            return InteractionResult.FAIL;
        }
        String code = MutagenItem.getCodename(stack).orElse(null);
        if (code == null) {
            return InteractionResult.FAIL;
        }
        if (!player.m_9236_().f_46443_) {
            Allele allele = Allele.byCode(code.charAt(0));
            if (allele == null) {
                player.m_5661_((Component)Component.m_237115_((String)"tip.fruitfulfun.invalidMutagen"), true);
                return InteractionResult.FAIL;
            }
            stack.m_41774_(1);
            ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
            if (!player.m_36356_(bottle)) {
                bee.m_19983_(bottle);
            }
            bee.m_146852_(GameEvent.f_223704_, (Entity)player);
            bee.m_7292_(new MobEffectInstance((MobEffect)BeeModule.MUTAGEN_EFFECT.get(), 1200, allele.index, true, true, false));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }

    public static Optional<String> getCodename(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(nbt -> nbt.m_128425_("Type", 8)).map(nbt -> nbt.m_128461_("Type"));
    }

    public static String getClientName(String codename) {
        if (Platform.isPhysicalClient() && Minecraft.m_91087_().f_91074_ != null) {
            return FFPlayer.of(Minecraft.m_91087_().f_91074_).fruits$getGeneName(codename);
        }
        return codename;
    }

    public ItemStack randomMutagen(boolean containsImperfect, @Nullable RandomSource random) {
        if (random == null) {
            random = RANDOM;
        }
        if (containsImperfect && random.m_188501_() < FFCommonConfig.imperfectMutagenChance) {
            return this.imperfectMutagen();
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        Allele allele = (Allele)Util.m_214621_(List.copyOf(Allele.values()), (RandomSource)random);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("Type", String.valueOf(allele.codename));
        tag.m_128405_("Color", allele.color);
        return stack;
    }

    public ItemStack imperfectMutagen() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128379_("Imperfect", true);
        return stack;
    }

    public boolean isImperfect(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_("Imperfect");
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean bl) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!this.isImperfect(stack) && MutagenItem.getCodename(stack).isEmpty()) {
                stack.m_41774_(1);
                player.m_36356_(this.randomMutagen(false, player.m_217043_()));
            }
        }
    }
}

