/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.genetics;

import net.minecraft.util.RandomSource;
import snownee.fruits.bee.genetics.Allele;

public class Locus {
    private final Allele type;
    private byte data;

    public Locus(Allele type) {
        this.type = type;
        this.data = type.defaultData;
    }

    public void randomize(RandomSource random) {
        byte gene1 = this.type.randomize(random);
        byte gene2 = this.type.randomize(random);
        this.data = (byte)(gene1 << 4 | gene2);
    }

    public byte getData() {
        return this.data;
    }

    public int getHigh() {
        return (this.data & 0xF0) >> 4;
    }

    public int getLow() {
        return this.data & 0xF;
    }

    public Allele getType() {
        return this.type;
    }

    public void setData(byte b) {
        this.data = b;
        if (!this.type.allowedValues.contains(this.getHigh()) || !this.type.allowedValues.contains(this.getLow())) {
            this.data = this.type.defaultData;
        }
    }
}

