/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.genetics;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.saveddata.SavedData;
import snownee.fruits.bee.genetics.Allele;

public class GeneticData
extends SavedData {
    private final Map<String, AlleleRecord> alleles = Maps.newHashMap();

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CompoundTag alleleTag = new CompoundTag();
        for (Map.Entry<String, AlleleRecord> entry : this.alleles.entrySet()) {
            CompoundTag recordTag = new CompoundTag();
            recordTag.m_128359_("Code", entry.getValue().code);
            recordTag.m_128405_("Index", entry.getValue().index);
            alleleTag.m_128365_(entry.getKey(), (Tag)recordTag);
        }
        compoundTag.m_128365_("Alleles", (Tag)alleleTag);
        return compoundTag;
    }

    public static GeneticData load(CompoundTag compoundTag) {
        GeneticData data = new GeneticData();
        CompoundTag alleleTag = compoundTag.m_128469_("Alleles");
        for (String key : alleleTag.m_128431_()) {
            CompoundTag recordTag = alleleTag.m_128469_(key);
            data.alleles.put(key, new AlleleRecord(recordTag.m_128461_("Code"), recordTag.m_128451_("Index")));
        }
        data.m_77762_();
        return data;
    }

    public void initAlleles(long seed) {
        RandomSource random = RandomSource.m_216335_((long)seed);
        for (Allele allele : Allele.values()) {
            AlleleRecord alleleRecord = this.alleles.get(allele.name);
            if (alleleRecord != null) {
                allele.codename = alleleRecord.code.charAt(0);
                allele.index = alleleRecord.index;
                random.m_188503_(26);
                random.m_188503_(255);
            } else {
                int codename = random.m_188503_(26);
                while (Allele.byCode((char)(65 + codename)) != null) {
                    codename = (codename + 1) % 26;
                }
                allele.codename = (char)(65 + codename);
                int index = random.m_188503_(255);
                while (Allele.byIndex(index) != null) {
                    index = (index + 31) % 255;
                }
                allele.index = index;
                this.alleles.put(allele.name, new AlleleRecord(String.valueOf(allele.codename), allele.index));
                this.m_77762_();
            }
            allele.color = Mth.m_14169_((float)((float)allele.index / 254.0f), (float)0.86f, (float)0.86f);
        }
        Allele.BY_CODE = Allele.values().stream().sorted(Comparator.comparingInt(a -> a.codename)).toList();
    }

    public record AlleleRecord(String code, int index) {
    }
}

