/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.genetics;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import snownee.fruits.FFCommonConfig;

public class Allele {
    public static final Map<String, Allele> REGISTRY = Maps.newLinkedHashMap();
    public static List<Allele> BY_CODE = List.of();
    public static final Allele RAINC = Allele.register(new Allele("RC", 2, FFCommonConfig.mutationRateRC));
    public static final Allele FANCY = Allele.register(new Allele("FC", 3, FFCommonConfig.mutationRateFC));
    public static final Allele FEAT1 = Allele.register(new Allele("FT1", 3, FFCommonConfig.mutationRateFT1));
    public static final Allele FEAT2 = Allele.register(new Allele("FT2", 3, FFCommonConfig.mutationRateFT2));
    public final String name;
    public final int defaultValue;
    public final byte defaultData;
    public final IntList allowedValues;
    public final float mutationRate;
    public char codename = (char)48;
    public int index = -1;
    public int color;

    public static Collection<Allele> values() {
        return REGISTRY.values();
    }

    public static Collection<Allele> sortedByCode() {
        return BY_CODE;
    }

    public static Allele register(Allele type) {
        REGISTRY.put(type.name, type);
        return type;
    }

    public Allele(String name, int allowedValues, float mutationRate) {
        this.name = name;
        this.mutationRate = mutationRate;
        this.defaultValue = 0;
        this.defaultData = 0;
        this.allowedValues = IntImmutableList.toList((IntStream)IntStream.range(0, allowedValues));
    }

    public static Allele byIndex(int i) {
        for (Allele allele : Allele.values()) {
            if (allele.index != i) continue;
            return allele;
        }
        return null;
    }

    public static Allele byCode(char c) {
        for (Allele allele : Allele.values()) {
            if (allele.codename != c) continue;
            return allele;
        }
        return null;
    }

    public byte maybeMutate(byte data, RandomSource random, boolean highMutation) {
        if (highMutation && random.m_188501_() < FFCommonConfig.mutagenMutationRate) {
            return (byte)this.allowedValues.getInt(random.m_188503_(this.allowedValues.size()));
        }
        if (this.mutationRate > 0.0f && random.m_188501_() < this.mutationRate) {
            return (byte)this.allowedValues.getInt(random.m_188503_(this.allowedValues.size()));
        }
        return data;
    }

    public byte randomize(RandomSource random) {
        return this.maybeMutate((byte)this.defaultValue, random, false);
    }

    public Component getDisplayName(int data) {
        return Component.m_237113_((String)(this.name + (data + 1)));
    }
}

