/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.bee.network.CInspectBeePacket;
import snownee.fruits.bee.network.InspectTarget;
import snownee.fruits.bee.network.SInspectBeeReplyPacket;
import snownee.fruits.compat.jade.JadeCompat;
import snownee.fruits.duck.FFPlayer;

public class InspectorClientHandler {
    public static final int ANALYZE_TICKS = 12;
    @Nullable
    public static InspectTarget inspectingBee;
    private static int hoverTicks;
    private static boolean jadeHint;
    private static boolean holdAlt;
    private static long holdAltStart;
    private static int pageNow;

    public static void tick(Minecraft mc) {
        Bee bee;
        Entity entity;
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        if (!mc.f_91074_.m_6117_() || !BeeModule.INSPECTOR.is(mc.f_91074_.m_21211_())) {
            InspectorClientHandler.reset();
            return;
        }
        long millis = Util.m_137550_();
        boolean alt = Screen.m_96639_();
        if (!holdAlt && alt) {
            holdAltStart = millis;
        } else if (holdAlt && !alt && millis - holdAltStart < 500L) {
            pageNow += Screen.m_96637_() ? -1 : 1;
            pageNow = Math.floorMod(pageNow, 3);
        }
        holdAlt = alt;
        InspectTarget target = InspectTarget.find((Level)mc.f_91073_, mc.f_91077_);
        if (target != null && (!((entity = target.getEntity((Level)mc.f_91073_)) instanceof Bee) || (bee = (Bee)entity).m_21224_())) {
            target = null;
        }
        if (target == null) {
            InspectorClientHandler.reset();
            return;
        }
        if (!Objects.equals(target, inspectingBee)) {
            inspectingBee = target;
            hoverTicks = 0;
            if (!Hooks.jade) {
                mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"tip.fruitfulfun.analyzing"), true);
                if (jadeHint && !mc.f_91074_.m_21206_().m_150930_(Items.f_42614_)) {
                    jadeHint = false;
                    mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"tip.fruitfulfun.recommendJade"), false);
                }
            }
        }
        if (++hoverTicks == 12) {
            CInspectBeePacket.I.sendToServer(inspectingBee::toNetwork);
            if (Hooks.jade) {
                JadeCompat.ensureVisibility(target.getClass() == InspectTarget.EntityTarget.class);
            }
        }
    }

    public static void reset() {
        inspectingBee = null;
        hoverTicks = 0;
    }

    public static void writeToBook(LocalPlayer player, List<Trait> traits, List<String> pollens, List<SInspectBeeReplyPacket.GeneRecord> genes) {
        ItemStack stack = player.m_21206_();
        if (!stack.m_150930_(Items.f_42614_)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("pages") && tag.m_128437_("pages", 8).size() >= 97) {
            player.m_5661_((Component)Component.m_237115_((String)"tip.fruitfulfun.bookIsFull"), true);
            return;
        }
        player.m_6986_(stack, InteractionHand.OFF_HAND);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof BookEditScreen)) {
            return;
        }
        BookEditScreen screen2 = (BookEditScreen)screen;
        List pages = screen2.f_98070_;
        if (!pages.isEmpty() && ((String)pages.get(pages.size() - 1)).isBlank()) {
            pages.remove(pages.size() - 1);
        }
        screen2.f_98069_ = pages.size();
        screen2.f_98066_ = true;
        ArrayList lines = Lists.newArrayList();
        lines.add(I18n.m_118938_((String)"text.fruitfulfun.pollen", (Object[])new Object[0]));
        for (String pollen : pollens) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)pollen));
            if (block == Blocks.f_50016_) {
                lines.add("- " + StringUtils.capitalize((String)pollen.replace('_', ' ')));
                continue;
            }
            lines.add("- " + block.m_49954_().getString());
        }
        if (pollens.isEmpty()) {
            lines.add(I18n.m_118938_((String)"text.fruitfulfun.pollen.none", (Object[])new Object[0]));
        }
        pages.add(String.join((CharSequence)"\n", lines));
        lines.clear();
        lines.add(I18n.m_118938_((String)"text.fruitfulfun.trait", (Object[])new Object[0]));
        for (Trait trait : traits) {
            String name = trait.getDisplayName().getString();
            String desc = trait.getDescription().getString();
            lines.add(I18n.m_118938_((String)"text.fruitfulfun.trait.pair", (Object[])new Object[]{name, desc}));
        }
        if (traits.isEmpty()) {
            lines.add(I18n.m_118938_((String)"text.fruitfulfun.trait.none", (Object[])new Object[0]));
        }
        pages.add(String.join((CharSequence)"\n", lines));
        lines.clear();
        lines.add(I18n.m_118938_((String)"text.fruitfulfun.gene", (Object[])new Object[0]));
        boolean hasDesc = false;
        FFPlayer ffPlayer = FFPlayer.of(player);
        for (SInspectBeeReplyPacket.GeneRecord gene : genes) {
            String desc = ffPlayer.fruits$getGeneDesc(gene.code());
            if (desc.isEmpty()) continue;
            hasDesc = true;
            break;
        }
        for (SInspectBeeReplyPacket.GeneRecord gene : genes) {
            String code = ffPlayer.fruits$getGeneName(gene.code());
            if (hasDesc) {
                String desc = ffPlayer.fruits$getGeneDesc(gene.code());
                if (desc.isEmpty()) {
                    lines.add(I18n.m_118938_((String)"text.fruitfulfun.gene.unnamed", (Object[])new Object[]{code}));
                } else {
                    lines.add(desc);
                }
            }
            String gene1 = code + gene.high();
            String gene2 = code + gene.low();
            lines.add(I18n.m_118938_((String)"text.fruitfulfun.gene.pair", (Object[])new Object[]{gene1, gene2}));
        }
        pages.add(String.join((CharSequence)"\n", lines));
        lines.clear();
    }

    public static boolean startUsing() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        InspectTarget target = InspectTarget.find((Level)level, Minecraft.m_91087_().f_91077_);
        return target != null && target.getEntity((Level)level) instanceof Bee;
    }

    public static int getPageNow() {
        return pageNow;
    }

    public static void setPageNow(int pageNow) {
        InspectorClientHandler.pageNow = Math.floorMod(pageNow, 3);
    }

    public static boolean isAnalyzing() {
        return inspectingBee != null && hoverTicks < 12;
    }

    public static int getHoverTicks() {
        return hoverTicks;
    }

    static {
        jadeHint = true;
    }
}

