/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.HybridizingRecipe;
import snownee.kiwi.util.Util;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.type.BlockKeyRecipeType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

public class HybridizingRecipeType
extends BlockKeyRecipeType<LycheeContext, HybridizingRecipe> {
    public HybridizingRecipeType(String name, Class<HybridizingRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    public static void removeOverflownPollens(Bee bee) {
        BeeAttributes attributes = BeeAttributes.of(bee);
        List<String> pollens = attributes.getPollens();
        if (pollens.size() > 3) {
            int toRemove = pollens.size() - 3;
            while (toRemove-- > 0) {
                pollens.remove(0);
            }
        }
    }

    public void buildCache() {
        super.buildCache();
        this.recipesByBlock.clear();
        this.anyBlockRecipes.clear();
        Stream<HybridizingRecipe> stream = CommonProxy.recipes((RecipeType)this).stream().filter($ -> !$.ghost);
        if (this.clazz.isAssignableFrom(Comparable.class)) {
            stream = stream.sorted();
        }
        this.recipes = stream.toList();
        HashMultimap multimap = HashMultimap.create();
        for (HybridizingRecipe hybridizingRecipe : this.recipes) {
            hybridizingRecipe.endingStep().stream().map(ResourceLocation::new).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7745_(arg_0)).forEach(arg_0 -> HybridizingRecipeType.lambda$buildCache$1((Multimap)multimap, hybridizingRecipe, arg_0));
        }
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            list.sort(null);
            this.recipesByBlock.put((Block)entry.getKey(), list);
        }
    }

    public void onPollinateComplete(Bee bee) {
        Pair result;
        if (this.isEmpty()) {
            return;
        }
        BlockPos flowerPos = bee.m_27851_();
        if (flowerPos == null) {
            return;
        }
        Level level = bee.m_9236_();
        BlockState state = level.m_8055_(flowerPos);
        if (state.m_60795_()) {
            return;
        }
        Block block = state.m_60734_();
        String newPollen = Util.trimRL((ResourceLocation)BuiltInRegistries.f_256975_.m_7981_((Object)block));
        BeeAttributes attributes = BeeAttributes.of(bee);
        List<String> pollens = attributes.getPollens();
        pollens.remove(newPollen);
        pollens.add(newPollen);
        if (!this.has(state)) {
            return;
        }
        boolean isBigFlowerUpper = false;
        if (block instanceof DoublePlantBlock && state.m_61138_((Property)DoublePlantBlock.f_52858_) && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
            state = level.m_8055_(flowerPos = flowerPos.m_7495_());
            if (block != state.m_60734_()) {
                return;
            }
            isBigFlowerUpper = true;
        }
        if ((result = this.process(bee.m_9236_(), state, this.buildContext(bee, flowerPos, state))) != null) {
            level.m_46796_(2005, flowerPos, 0);
            if (isBigFlowerUpper) {
                level.m_46796_(2005, flowerPos.m_7494_(), 0);
            }
            pollens.clear();
        }
    }

    public Supplier<LycheeContext> buildContext(Bee bee, BlockPos flowerPos, BlockState state) {
        return () -> {
            LycheeContext.Builder builder = new LycheeContext.Builder(bee.m_9236_());
            builder.withRandom(bee.m_217043_());
            builder.withParameter(LootContextParams.f_81455_, (Object)bee);
            builder.withParameter(LootContextParams.f_81461_, (Object)state);
            builder.withParameter(LootContextParams.f_81460_, (Object)Vec3.m_82539_((Vec3i)flowerPos));
            builder.withParameter(LycheeLootContextParams.BLOCK_POS, (Object)flowerPos);
            return builder.create(((HybridizingRecipeType)((Object)((Object)BeeModule.RECIPE_TYPE.get()))).contextParamSet);
        };
    }

    private static /* synthetic */ void lambda$buildCache$1(Multimap multimap, HybridizingRecipe recipe, Block $) {
        multimap.put((Object)$, (Object)recipe);
    }
}

