/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.kiwi.util.Util;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.json.JsonPointer;

public class HybridizingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyRecipe<HybridizingRecipe> {
    public Collection<String> pollens = List.of();
    public Collection<String> endingStep = List.of();
    public final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();

    public HybridizingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(LycheeContext ctx, Level worldIn) {
        BeeAttributes attributes = BeeAttributes.of(ctx.getParam(LootContextParams.f_81455_));
        return attributes.getPollens().size() >= this.pollens.size() && attributes.getPollens().containsAll(this.pollens);
    }

    public LycheeRecipe.Serializer<?> getSerializer() {
        return (LycheeRecipe.Serializer)BeeModule.SERIALIZER.get();
    }

    public LycheeRecipeType<?, ?> getType() {
        return (LycheeRecipeType)BeeModule.RECIPE_TYPE.get();
    }

    public int compareTo(@NotNull HybridizingRecipe o) {
        return 0;
    }

    public BlockPredicate getBlock() {
        return BlockPredicate.f_17902_;
    }

    public Collection<String> endingStep() {
        if (this.endingStep.isEmpty()) {
            return this.pollens;
        }
        return this.endingStep;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public void refreshIngredients() {
        this.ingredients.clear();
        for (String pollen : this.pollens) {
            Item item = ((Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)pollen))).m_5456_();
            if (item == Items.f_41852_) continue;
            this.ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
    }

    public IntList getItemIndexes(JsonPointer pointer) {
        return IntList.of();
    }

    public void addInvisibleInputs(Consumer<ItemStack> acceptor) {
        for (String pollen : this.pollens) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)pollen));
            if (!(block instanceof FruitLeavesBlock)) continue;
            FruitLeavesBlock leavesBlock = (FruitLeavesBlock)block;
            acceptor.accept(new ItemStack((ItemLike)leavesBlock.type.get().sapling.get()));
        }
    }

    public void addInvisibleOutputs(Consumer<ItemStack> acceptor) {
        ILycheeRecipe.filterHidden((Stream)this.getAllActions()).flatMap($ -> $.getItemOutputs().stream()).map(ItemStack::m_41720_).distinct().map($ -> {
            Block patt3747$temp = Block.m_49814_((Item)$);
            if (patt3747$temp instanceof FruitLeavesBlock) {
                FruitLeavesBlock block = (FruitLeavesBlock)patt3747$temp;
                return new ItemStack((ItemLike)block.type.get().sapling.get());
            }
            return null;
        }).filter(Objects::nonNull).forEach(acceptor);
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<HybridizingRecipe> {
        public Serializer() {
            super(HybridizingRecipe::new);
        }

        public void fromJson(HybridizingRecipe recipe, JsonObject jsonObject) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"pollens");
            Preconditions.checkArgument((!ingredients.isEmpty() && ingredients.size() <= 4 ? 1 : 0) != 0, (Object)"Size of pollens has to be in [1, 4]");
            recipe.pollens = Sets.newLinkedHashSetWithExpectedSize((int)ingredients.size());
            for (JsonElement element : ingredients) {
                String s = element.getAsString();
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)s));
                Preconditions.checkArgument((block != Blocks.f_50016_ ? 1 : 0) != 0, (Object)("Unknown block: " + s));
                recipe.pollens.add(Util.trimRL((String)s));
            }
            Preconditions.checkArgument((recipe.pollens.size() == Set.copyOf(recipe.pollens).size() ? 1 : 0) != 0, (Object)"Pollens must be unique");
            JsonArray endingStep = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"ending_step", null);
            if (endingStep != null) {
                Preconditions.checkArgument((!endingStep.isEmpty() && endingStep.size() <= 4 ? 1 : 0) != 0, (Object)"Size of ending_step has to be in [1, 4]");
                recipe.endingStep = Sets.newLinkedHashSetWithExpectedSize((int)endingStep.size());
                for (JsonElement element : endingStep) {
                    String s = element.getAsString();
                    Preconditions.checkArgument((boolean)recipe.pollens.contains(s), (Object)"Ending step must be in pollens");
                    recipe.endingStep.add(Util.trimRL((String)s));
                }
            }
            recipe.refreshIngredients();
        }

        public void fromNetwork(HybridizingRecipe recipe, FriendlyByteBuf buf) {
            recipe.pollens = List.copyOf(buf.m_236845_(FriendlyByteBuf::m_130277_));
            recipe.endingStep = List.copyOf(buf.m_236845_(FriendlyByteBuf::m_130277_));
            recipe.refreshIngredients();
        }

        public void toNetwork0(FriendlyByteBuf buf, HybridizingRecipe recipe) {
            buf.m_236828_(recipe.pollens, FriendlyByteBuf::m_130070_);
            buf.m_236828_(recipe.endingStep, FriendlyByteBuf::m_130070_);
        }
    }
}

