/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.Trait;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public record BeeHasTrait(Trait trait) implements ContextualCondition
{
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return (ContextualConditionType)BeeModule.BEE_HAS_TRAIT.get();
    }

    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        BeeAttributes attributes;
        Entity entity = (Entity)ctx.getParam(LootContextParams.f_81455_);
        if (entity instanceof Bee && (attributes = BeeAttributes.of(entity)).hasTrait(this.trait)) {
            return times;
        }
        return 0;
    }

    public MutableComponent getDescription(boolean inverted) {
        String key = this.makeDescriptionId(inverted);
        return Component.m_237110_((String)key, (Object[])new Object[]{this.trait.getDisplayName().m_130940_(ChatFormatting.WHITE)});
    }

    public static class Type
    extends ContextualConditionType<BeeHasTrait> {
        public BeeHasTrait fromJson(JsonObject jsonObject) {
            String s = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"trait");
            Trait trait = Trait.REGISTRY.get(s);
            Preconditions.checkNotNull((Object)trait, (String)"Unknown trait: %s", (Object)s);
            return new BeeHasTrait(trait);
        }

        public void toJson(BeeHasTrait condition, JsonObject jsonObject) {
            jsonObject.addProperty("trait", condition.trait.name());
        }

        public BeeHasTrait fromNetwork(FriendlyByteBuf buf) {
            return new BeeHasTrait(Trait.REGISTRY.get(buf.m_130277_()));
        }

        public void toNetwork(BeeHasTrait condition, FriendlyByteBuf buf) {
            buf.m_130070_(condition.trait.name());
        }
    }
}

