/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.Locus;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.duck.FFBee;

public class BeeAttributes {
    private static final UUID SPEED_MODIFIER = UUID.fromString("d21ceda4-191f-47e7-a7c7-f5eff7012bdd");
    private static final UUID HEALTH_MODIFIER = UUID.fromString("aa3feeef-be3e-4d05-b98c-689bae6e22e7");
    private static final UUID DAMAGE_MODIFIER = UUID.fromString("168df6fe-fa8d-426f-8198-d89a5bc01397");
    private final List<String> pollens = Lists.newArrayList();
    private final Map<Allele, Locus> loci = Maps.newIdentityHashMap();
    private final Set<Trait> traits = Sets.newIdentityHashSet();
    public boolean dirty;
    private ItemStack saddle = ItemStack.f_41583_;
    private List<UUID> trusted = List.of();
    @Nullable
    private ResourceLocation texture;
    private long mutagenEndsIn;

    public static BeeAttributes of(Object bee) {
        return ((FFBee)bee).fruits$getBeeAttributes();
    }

    public void toNBT(CompoundTag data) {
        if (!this.saddle.m_41619_()) {
            data.m_128365_("Saddle", (Tag)this.saddle.m_41739_(new CompoundTag()));
        }
        if (!this.trusted.isEmpty()) {
            ListTag trustedList = new ListTag();
            for (UUID uUID : this.trusted) {
                trustedList.add((Object)StringTag.m_129297_((String)uUID.toString()));
            }
            data.m_128365_("Trusted", (Tag)trustedList);
        }
        if (!this.pollens.isEmpty()) {
            ListTag pollensList = new ListTag();
            for (String string : this.pollens) {
                pollensList.add((Object)StringTag.m_129297_((String)string));
            }
            data.m_128365_("Pollens", (Tag)pollensList);
        }
        if (!this.loci.isEmpty()) {
            CompoundTag lociTag = new CompoundTag();
            for (Map.Entry entry : this.loci.entrySet()) {
                lociTag.m_128344_(((Allele)entry.getKey()).name, ((Locus)entry.getValue()).getData());
            }
            data.m_128365_("Genes", (Tag)lociTag);
        }
    }

    public void fromNBT(CompoundTag data, Bee bee) {
        this.saddle = ItemStack.f_41583_;
        if (data.m_128441_("Saddle")) {
            this.saddle = ItemStack.m_41712_((CompoundTag)data.m_128469_("Saddle"));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Tag tag : data.m_128437_("Trusted", 8)) {
            builder.add((Object)UUID.fromString(tag.m_7916_()));
        }
        this.trusted = builder.build();
        this.pollens.clear();
        for (Tag tag : data.m_128437_("Pollens", 8)) {
            this.pollens.add(tag.m_7916_());
        }
        this.loci.clear();
        CompoundTag lociTag = data.m_128469_("Genes");
        for (Allele allele : Allele.REGISTRY.values()) {
            Locus locus = new Locus(allele);
            if (lociTag.m_128441_(allele.name)) {
                locus.setData(lociTag.m_128445_(allele.name));
            }
            this.loci.put(allele, locus);
        }
        this.updateTraits(bee);
    }

    public void setTrusted(List<UUID> trusted) {
        this.trusted = trusted;
        this.dirty = true;
    }

    public void addTrusted(UUID uuid) {
        if (this.trusted.contains(uuid)) {
            return;
        }
        this.setTrusted((List<UUID>)ImmutableList.builder().addAll(this.trusted).add((Object)uuid).build());
    }

    public List<UUID> getTrusted() {
        return this.trusted;
    }

    public List<String> getPollens() {
        return this.pollens;
    }

    public boolean isSaddled() {
        return !this.saddle.m_41619_();
    }

    public boolean isSaddleable() {
        return this.hasTrait(Trait.MOUNTABLE);
    }

    public void setSaddle(ItemStack saddle) {
        this.saddle = saddle;
        this.dirty = true;
    }

    public ItemStack getSaddle() {
        return this.saddle;
    }

    public boolean trusts(UUID uuid) {
        return this.trusted.contains(uuid);
    }

    public void breedFrom(BeeAttributes parent1, Allele allele1, BeeAttributes parent2, Allele allele2, Bee bee) {
        RandomSource random = bee.m_217043_();
        Iterator<Allele> iterator = Allele.values().iterator();
        while (iterator.hasNext()) {
            Allele allele;
            byte gene1 = parent1.pickAllele(allele, random, (allele = iterator.next()) == allele1);
            byte gene2 = parent2.pickAllele(allele, random, allele == allele2);
            Locus locus = new Locus(allele);
            locus.setData((byte)(gene1 << 4 | gene2));
            this.loci.put(allele, locus);
        }
        this.updateTraits(bee);
    }

    public void updateTraits(Bee bee) {
        this.traits.clear();
        if (this.allGene(Allele.RAINC, 1)) {
            this.traits.add(Trait.RAIN_CAPABLE);
        }
        if (this.allGene(Allele.FANCY, 1)) {
            this.traits.add(Trait.PINK);
        } else if (this.allGene(Allele.FANCY, 2)) {
            this.traits.add(Trait.WITHER_TOLERANT);
        }
        boolean lazy = false;
        if (this.allGene(Allele.FEAT1, 1)) {
            this.traits.add(Trait.LAZY);
            this.traits.add(Trait.MILD);
            lazy = true;
        } else if (this.anyGene(Allele.FEAT1, 1)) {
            this.traits.add(Trait.MILD);
        }
        if (this.allGene(Allele.FEAT1, 2)) {
            this.traits.add(Trait.FASTER);
        } else if (this.anyGene(Allele.FEAT1, 2)) {
            this.traits.add(Trait.FAST);
        }
        if (this.anyGene(Allele.FEAT1, 2) && !this.hasTrait(Trait.MILD)) {
            this.traits.add(Trait.WARRIOR);
        } else if (this.allGene(Allele.FEAT2, 1)) {
            this.traits.add(Trait.ADVANCED_POLLINATION);
        }
        if (this.allGene(Allele.FEAT2, 2)) {
            this.traits.add(Trait.MOUNTABLE);
        }
        this.updateTexture();
        if (bee.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance speedInstance = Objects.requireNonNull(bee.m_21051_(Attributes.f_22280_));
        AttributeInstance healthInstance = Objects.requireNonNull(bee.m_21051_(Attributes.f_22276_));
        AttributeInstance damageInstance = Objects.requireNonNull(bee.m_21051_(Attributes.f_22281_));
        speedInstance.m_22127_(SPEED_MODIFIER);
        healthInstance.m_22127_(HEALTH_MODIFIER);
        damageInstance.m_22127_(DAMAGE_MODIFIER);
        if (this.hasTrait(Trait.FASTER)) {
            speedInstance.m_22125_(new AttributeModifier(SPEED_MODIFIER, "Genetic speed bonus", 0.25, AttributeModifier.Operation.ADDITION));
        } else if (this.hasTrait(Trait.FAST)) {
            speedInstance.m_22125_(new AttributeModifier(SPEED_MODIFIER, "Genetic speed bonus", 0.15, AttributeModifier.Operation.ADDITION));
        }
        if (lazy || this.hasTrait(Trait.WARRIOR)) {
            float healthRatio = bee.m_21223_() / bee.m_21233_();
            if (lazy) {
                healthInstance.m_22125_(new AttributeModifier(HEALTH_MODIFIER, "Genetic health bonus", 5.0, AttributeModifier.Operation.ADDITION));
            } else {
                healthInstance.m_22125_(new AttributeModifier(HEALTH_MODIFIER, "Genetic health bonus", 10.0, AttributeModifier.Operation.ADDITION));
                damageInstance.m_22125_(new AttributeModifier(DAMAGE_MODIFIER, "Genetic damage bonus", 2.0, AttributeModifier.Operation.ADDITION));
            }
            bee.m_21153_(healthRatio * bee.m_21233_());
        }
        this.dirty = true;
    }

    public void updateTexture() {
        if (this.hasTrait(Trait.PINK)) {
            this.setTexture(new ResourceLocation("fruitfulfun", "pink_bee"));
        } else if (this.hasTrait(Trait.WITHER_TOLERANT)) {
            this.setTexture(new ResourceLocation("fruitfulfun", "wither_bee"));
        } else {
            this.setTexture(null);
        }
    }

    public boolean hasTrait(Trait trait) {
        return Hooks.bee && this.traits.contains(trait);
    }

    public Locus getLocus(Allele allele) {
        return this.loci.computeIfAbsent(allele, Locus::new);
    }

    private byte pickAllele(Allele allele, RandomSource random, boolean highMutation) {
        Locus locus = this.getLocus(allele);
        int gene = random.m_188499_() ? locus.getHigh() : locus.getLow();
        return allele.maybeMutate((byte)gene, random, highMutation);
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(@Nullable ResourceLocation texture) {
        this.texture = texture;
        this.dirty = true;
    }

    public boolean anyGene(Allele allele, int gene) {
        Locus locus = this.getLocus(allele);
        return locus.getHigh() == gene || locus.getLow() == gene;
    }

    public boolean allGene(Allele allele, int gene) {
        Locus locus = this.getLocus(allele);
        return locus.getHigh() == gene && locus.getLow() == gene;
    }

    public void randomize(Bee bee) {
        for (Allele type : Allele.values()) {
            Locus locus = new Locus(type);
            locus.randomize(bee.m_217043_());
            this.loci.put(type, locus);
        }
        this.updateTraits(bee);
    }

    public Map<Allele, Locus> getLoci() {
        return this.loci;
    }

    public Set<Trait> getTraits() {
        return this.traits;
    }

    public void setTraits(List<Trait> list) {
        this.traits.clear();
        this.traits.addAll(list);
    }

    public void setMutagenEndsIn(long mutagenEndsIn, long gameTime) {
        if (this.mutagenEndsIn == mutagenEndsIn) {
            return;
        }
        if (mutagenEndsIn == 0L && this.mutagenEndsIn <= gameTime) {
            return;
        }
        this.mutagenEndsIn = mutagenEndsIn;
        this.dirty = true;
    }

    public long getMutagenEndsIn() {
        return this.mutagenEndsIn;
    }
}

