/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.CoreModule;
import snownee.fruits.FFClientConfig;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.cherry.block.CherryLeavesBlock;
import snownee.fruits.duck.FFBee;
import snownee.fruits.food.FoodModule;
import snownee.fruits.util.CommonProxy;
import snownee.kiwi.loader.Platform;

public final class Hooks {
    public static boolean bee;
    public static boolean food;
    public static boolean farmersdelight;
    public static boolean ritual;
    public static boolean vac;
    public static boolean curios;
    public static boolean supplementaries;
    public static boolean jade;
    private static final int[] SURFACE_CHECKS;

    private Hooks() {
    }

    public static Predicate<BlockState> wrapPollinationPredicate(Predicate<BlockState> original) {
        return state -> {
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return false;
            }
            Block patt3432$temp = state.m_60734_();
            if (patt3432$temp instanceof FruitLeavesBlock) {
                FruitLeavesBlock block = (FruitLeavesBlock)patt3432$temp;
                if (block instanceof CherryLeavesBlock) {
                    return block.notPlacedByPlayer((BlockState)state);
                }
                if (!block.canGrow((BlockState)state)) {
                    return false;
                }
                return (Integer)state.m_61143_((Property)FruitLeavesBlock.AGE) == 2;
            }
            if (state.m_60734_() instanceof LeavesBlock && state.m_61138_((Property)LeavesBlock.f_54419_) && ((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) {
                return false;
            }
            return original.test((BlockState)state);
        };
    }

    public static void modifyRayTraceResult(HitResult hitResult, Consumer<HitResult> consumer) {
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        Entity entity = ((EntityHitResult)hitResult).m_82443_();
        if (!CoreModule.SLIDING_DOOR.is((Object)entity.m_6095_())) {
            return;
        }
        Vec3 vec = hitResult.m_82450_();
        BlockPos pos = entity.m_20183_();
        if (vec.f_82480_ - (double)pos.m_123342_() >= 1.0) {
            pos = pos.m_7494_();
        }
        AABB intersection = entity.m_20191_().m_82323_(new AABB(pos));
        vec = intersection.m_82399_();
        consumer.accept((HitResult)new BlockHitResult(vec, Direction.UP, pos, false));
    }

    public static void hornHarvest(ServerLevel level, ServerPlayer player) {
        Advancement advancement;
        Vec3 eye = player.m_146892_();
        BlockPos eyePos = BlockPos.m_274446_((Position)eye);
        long count = level.m_8904_().m_27138_($ -> $.m_203656_(CoreModule.POI_TYPE), (Predicate)Predicates.alwaysTrue(), eyePos, 24, PoiManager.Occupancy.ANY).flatMap($ -> level.m_141902_($, (BlockEntityType)CoreModule.FRUIT_TREE.get()).stream()).peek($ -> Hooks.hornHarvest(level, player, $, eyePos, null)).count();
        if (count > 0L && (advancement = Hooks.advancement(level, "horn")) != null) {
            player.m_8960_().m_135988_(advancement, "_");
        }
    }

    public static Advancement advancement(ServerLevel level, String id) {
        return level.m_7654_().m_129889_().m_136041_(new ResourceLocation("fruitfulfun", "husbandry/fruitfulfun/" + id));
    }

    private static void hornHarvest(ServerLevel level, ServerPlayer player, FruitTreeBlockEntity core, BlockPos eyePos, Consumer<ItemEntity> consumer) {
        Set<BlockPos> leaves = core.getActiveLeaves();
        BlockPos corePos = core.m_58899_();
        if (leaves.isEmpty()) {
            BlockState blockState = level.m_8055_(eyePos);
            if (blockState.m_60734_() instanceof FruitLeavesBlock) {
                Iterable posList = BlockPos.m_121940_((BlockPos)corePos.m_7918_(-3, -1, -3), (BlockPos)corePos.m_7918_(3, 2, 3));
                FruitLeavesBlock.rangeDrop(level, posList, 0, core, consumer);
            }
        } else {
            for (BlockPos pos : leaves) {
                ItemEntity itemEntity;
                BlockState blockState = level.m_8055_(pos = corePos.m_121955_((Vec3i)pos));
                if (!(blockState.m_60734_() instanceof FruitLeavesBlock) || (itemEntity = FruitLeavesBlock.dropFruit(level, pos, blockState, core, 0)) == null || consumer == null) continue;
                consumer.accept(itemEntity);
            }
        }
        corePos = corePos.m_7495_();
        double dist = Math.sqrt(corePos.m_123331_((Vec3i)eyePos));
        BlockPositionSource dest = new BlockPositionSource(corePos);
        Vec3 eye = player.m_146892_();
        level.m_8767_((ParticleOptions)new VibrationParticleOption((PositionSource)dest, Math.max((int)(dist / 2.0), 4)), eye.f_82479_, eye.f_82480_ + 1.0, eye.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static InteractionResult playerInteractBee(Player player, InteractionHand hand, Bee bee) {
        BeeAttributes attributes = BeeAttributes.of(bee);
        Saddleable saddleable = (Saddleable)bee;
        ItemStack held = player.m_21120_(hand);
        if (BeeModule.INSPECTOR.is(held)) {
            return InteractionResult.PASS;
        }
        if (held.m_150930_(Items.f_42751_)) {
            if (!player.m_9236_().f_46443_) {
                attributes.getLocus(Allele.FEAT2).setData((byte)17);
                attributes.getPollens().add("fruitfulfun:apple_leaves");
                attributes.getPollens().add("wither_rose");
                attributes.updateTraits(bee);
            }
            return InteractionResult.CONSUME;
        }
        if (saddleable.m_6254_()) {
            boolean trusted;
            boolean bl = trusted = player.m_7500_() || attributes.trusts(player.m_20148_());
            if (CommonProxy.isShears(held)) {
                if (!trusted) {
                    ((FFBee)bee).fruits$roll();
                    return InteractionResult.FAIL;
                }
                ItemStack saddle = attributes.getSaddle();
                attributes.setSaddle(ItemStack.f_41583_);
                if (!player.m_9236_().f_46443_) {
                    held.m_41622_(1, (LivingEntity)player, $ -> $.m_21190_(hand));
                    bee.m_19983_(saddle);
                    bee.m_146852_(GameEvent.f_157781_, (Entity)player);
                    bee.m_9236_().m_6269_(null, (Entity)bee, (SoundEvent)BeeModule.BEE_SHEAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
            if (!bee.m_20160_() && !player.m_36341_()) {
                if (!trusted) {
                    ((FFBee)bee).fruits$roll();
                    return InteractionResult.FAIL;
                }
                if (!player.m_9236_().f_46443_) {
                    player.m_20329_((Entity)bee);
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
        } else if (held.m_150930_(Items.f_42450_) && saddleable.m_6741_()) {
            if (!player.m_9236_().f_46443_) {
                saddleable.m_5853_(SoundSource.NEUTRAL);
                attributes.setSaddle(held.m_41620_(1));
                player.m_9236_().m_220400_((Entity)bee, GameEvent.f_157811_, bee.m_20182_());
            }
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Vec3 getRiddenInput(Bee bee, Player player, Vec3 vec3) {
        BlockPos pos;
        Level level = bee.m_9236_();
        if (level.m_6042_().f_63857_()) {
            return new Vec3(0.0, -0.07, 0.0);
        }
        BeeAttributes attributes = BeeAttributes.of(bee);
        if (!attributes.hasTrait(Trait.RAIN_CAPABLE) && level.m_46758_(bee.m_20183_())) {
            return new Vec3(0.0, -0.07, 0.0);
        }
        float x = player.f_20900_ * 0.5f;
        float z = player.f_20902_;
        if ((z *= bee.m_20096_() ? 0.3f : 0.6f) <= 0.0f) {
            z *= 0.25f;
        }
        double y = 0.0;
        if (Hooks.tooFarFromSurface(level, bee.m_20183_())) {
            y = -0.07;
        } else if (player.m_7578_() && ((LocalPlayer)player).f_108618_.f_108572_) {
            y = 0.1;
        } else if (x != 0.0f || z != 0.0f) {
            y = Mth.m_14008_((double)(player.m_20154_().f_82480_ * 0.5), (double)-0.1, (double)0.1);
        }
        if (y >= 0.0 && (level.m_8055_(pos = BlockPos.m_274446_((Position)player.m_146892_())).m_60828_((BlockGetter)level, pos) || level.m_8055_(pos.m_7494_()).m_60828_((BlockGetter)level, pos))) {
            y = -0.07;
        }
        return new Vec3((double)x, y, (double)z);
    }

    public static boolean tooFarFromSurface(Level level, BlockPos pos) {
        int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        if (pos.m_123342_() > height) {
            return pos.m_123342_() - height > 15;
        }
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i : SURFACE_CHECKS) {
            mutable.m_142448_(pos.m_123342_() - i);
            if (!level.m_8055_((BlockPos)mutable).m_280555_()) continue;
            return false;
        }
        return true;
    }

    public static void spawnBeeFromBreeding(Bee parent1, Bee parent2, Bee baby) {
        ServerPlayer loveCause2;
        BeeAttributes babyAttributes = BeeAttributes.of(baby);
        ImmutableList.Builder builder = ImmutableList.builder();
        ServerPlayer loveCause1 = parent1.m_27592_();
        if (loveCause1 != null) {
            builder.add((Object)loveCause1.m_20148_());
            loveCause1.m_36220_(BeeModule.BEES_BRED);
        }
        if ((loveCause2 = parent2.m_27592_()) != null) {
            builder.add((Object)loveCause2.m_20148_());
            if (loveCause1 != loveCause2) {
                loveCause2.m_36220_(BeeModule.BEES_BRED);
            }
        }
        babyAttributes.setTrusted((List<UUID>)builder.build());
        if (bee) {
            babyAttributes.breedFrom(BeeAttributes.of(parent1), Hooks.mutagenAffectedAllele(parent1), BeeAttributes.of(parent2), Hooks.mutagenAffectedAllele(parent2), baby);
        }
    }

    private static Allele mutagenAffectedAllele(Bee bee) {
        MobEffectInstance effect = bee.m_21124_((MobEffect)BeeModule.MUTAGEN_EFFECT.get());
        if (effect == null) {
            return null;
        }
        return Allele.byIndex(effect.m_19564_());
    }

    public static Vec3 modifyExplosionDeltaMovement(Entity entity, double dx, double dy, double dz, float radius) {
        Vec3 deltaMovement = entity.m_20184_();
        if (Math.abs(deltaMovement.f_82479_ + (dx = dx * (double)radius * 0.5)) > 3.0) {
            dx = Mth.m_14008_((double)(deltaMovement.f_82479_ + dx), (double)-3.0, (double)3.0) - deltaMovement.f_82479_;
        }
        if (Math.abs(deltaMovement.f_82480_ + (dy = dy * (double)radius * 0.5 + (double)Mth.m_14205_((double)dy) * 0.1)) > 3.0) {
            dy = Mth.m_14008_((double)(deltaMovement.f_82480_ + dy), (double)-3.0, (double)3.0) - deltaMovement.f_82480_;
        }
        if (Math.abs(deltaMovement.f_82481_ + (dz = dz * (double)radius * 0.5)) > 3.0) {
            dz = Mth.m_14008_((double)(deltaMovement.f_82481_ + dz), (double)-3.0, (double)3.0) - deltaMovement.f_82481_;
        }
        return new Vec3(dx, dy, dz);
    }

    public static void appendEffectTooltip(Item item, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        List<MobEffectInstance> effects;
        if (!Platform.isPhysicalClient()) {
            return;
        }
        if (FFClientConfig.foodSpecialEffectTooltip && Hooks.shouldClearHarmfulEffects(item)) {
            tooltip.add((Component)Component.m_237115_((String)"tip.fruitfulfun.clearHarmfulEffects").m_130940_(ChatFormatting.BLUE));
        }
        FoodProperties properties = item.m_41473_();
        if (FFClientConfig.foodStatusEffectTooltip && properties != null && !(effects = properties.m_38749_().stream().filter($ -> $.getFirst() != null && ((Float)$.getSecond()).floatValue() > 0.0f).map(Pair::getFirst).toList()).isEmpty()) {
            PotionUtils.m_257410_(effects, tooltip, (float)1.0f);
        }
    }

    public static boolean shouldClearHarmfulEffects(Item item) {
        return food && (!farmersdelight || !Platform.isProduction()) && ((Block)FoodModule.HONEY_POMELO_TEA.get()).m_5456_() == item;
    }

    static {
        curios = Platform.isModLoaded((String)"curios");
        supplementaries = Platform.isModLoaded((String)"supplementaries");
        jade = Platform.isModLoaded((String)"jade");
        SURFACE_CHECKS = new int[]{15, 11, 7, 3, 14, 10, 6, 2, 13, 9, 5, 1, 12, 8, 4, 0};
    }
}

