/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import snownee.fruits.Hooks;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfig;

@KiwiConfig
public final class FFCommonConfig {
    @KiwiConfig.Range(min=0.0, max=100.0)
    public static int treeGrowingSpeed = 5;
    @KiwiConfig.Path(value="fruitDropMode.singleplayer")
    public static DropMode fruitDropModeSingleplayer = DropMode.Independent;
    @KiwiConfig.Path(value="fruitDropMode.multiplayer")
    public static DropMode fruitDropModeMultiplayer = DropMode.OneByOne;
    @KiwiConfig.Path(value="fruitTreeLifespan.min")
    public static int fruitTreeLifespanMin = 14;
    @KiwiConfig.Path(value="fruitTreeLifespan.max")
    public static int fruitTreeLifespanMax = 24;
    public static boolean appleSaplingFromHeroOfTheVillage = true;
    @KiwiConfig.GameRestart
    public static boolean villageAppleTreeWorldGen = true;
    public static String hornHarvestingInstrument = "minecraft:sing_goat_horn";
    public static boolean wanderingTraderSapling = true;
    @KiwiConfig.Range(min=0.0)
    public static int beeNaturalHealingInterval = 900;
    public static boolean mutagenRecipe = true;
    public static boolean redloveFruitUse = true;
    @KiwiConfig.Path(value="dragonBreath.fixExploit")
    public static boolean fixDragonBreathExploit = true;
    @KiwiConfig.GameRestart
    @KiwiConfig.Path(value="dragonBreath.dispenserCollecting")
    public static boolean dispenserCollectDragonBreath = true;
    @ConfigUI.Hide
    public static boolean leavesUsInPeaceIncompatibilityNotified;
    @KiwiConfig.GameRestart
    public static GeneticsDifficulty geneticsDifficulty;
    @KiwiConfig.GameRestart
    @KiwiConfig.Range(min=0.0, max=1.0)
    @KiwiConfig.Path(value="mutationRate.RC")
    public static float mutationRateRC;
    @KiwiConfig.GameRestart
    @KiwiConfig.Range(min=0.0, max=1.0)
    @KiwiConfig.Path(value="mutationRate.FC")
    public static float mutationRateFC;
    @KiwiConfig.GameRestart
    @KiwiConfig.Range(min=0.0, max=1.0)
    @KiwiConfig.Path(value="mutationRate.FT1")
    public static float mutationRateFT1;
    @KiwiConfig.GameRestart
    @KiwiConfig.Range(min=0.0, max=1.0)
    @KiwiConfig.Path(value="mutationRate.FT2")
    public static float mutationRateFT2;
    @KiwiConfig.Range(min=0.0, max=1.0)
    public static float imperfectMutagenChance;
    @KiwiConfig.Range(min=0.0, max=1.0)
    public static float mutagenMutationRate;

    public static DropMode getDropMode(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        return server != null && server.m_6982_() ? fruitDropModeMultiplayer : fruitDropModeSingleplayer;
    }

    public static boolean isMutagenRecipeEnabled() {
        return Hooks.bee && mutagenRecipe;
    }

    static {
        geneticsDifficulty = GeneticsDifficulty.Normal;
        mutationRateRC = 0.1f;
        mutationRateFC = 0.14f;
        mutationRateFT1 = 0.07f;
        mutationRateFT2 = 0.06f;
        imperfectMutagenChance = 0.15f;
        mutagenMutationRate = 0.8f;
    }

    public static enum DropMode {
        NoDrop,
        Independent,
        OneByOne;

    }

    public static enum GeneticsDifficulty {
        Easy,
        Normal;

    }
}

