/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.fruits.CoreFruitTypes;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.FFRegistries;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.block.entity.SlidingDoorEntity;
import snownee.fruits.block.grower.FruitTreeGrower;
import snownee.fruits.levelgen.foliageplacers.Fruitify;
import snownee.fruits.ritual.CollectDragonBreathDispenseBehavior;
import snownee.fruits.util.CommonProxy;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.NamedEntry;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.KiwiEntityTypeBuilder;
import snownee.kiwi.util.VanillaActions;

@KiwiModule
public final class CoreModule
extends AbstractModule {
    public static final BlockSetType CITRUS_SET_TYPE = new BlockSetType("fruitfulfun:citrus");
    public static final WoodType CITRUS_WOOD_TYPE = new WoodType(CITRUS_SET_TYPE.f_271253_(), CITRUS_SET_TYPE);
    @KiwiModule.NoItem
    public static final KiwiGO<Block> CITRUS_SIGN = CoreModule.go(() -> new StandingSignBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50095_), CITRUS_WOOD_TYPE));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> CITRUS_WALL_SIGN = CoreModule.go(() -> new WallSignBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50158_), CITRUS_WOOD_TYPE));
    @KiwiModule.Name(value="citrus_sign")
    @KiwiModule.Category(value={"functional"}, after={"cherry_hanging_sign"})
    public static final KiwiGO<Item> CITRUS_SIGN_ITEM = CoreModule.go(() -> new SignItem(CoreModule.itemProp().m_41487_(Items.f_42438_.m_41459_()), (Block)CITRUS_SIGN.get(), (Block)CITRUS_WALL_SIGN.get()));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> CITRUS_HANGING_SIGN = CoreModule.go(() -> new CeilingHangingSignBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_244319_), CITRUS_WOOD_TYPE));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> CITRUS_WALL_HANGING_SIGN = CoreModule.go(() -> new WallHangingSignBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_244093_), CITRUS_WOOD_TYPE));
    @KiwiModule.Name(value="citrus_hanging_sign")
    public static final KiwiGO<Item> CITRUS_HANGING_SIGN_ITEM = CoreModule.go(() -> new HangingSignItem((Block)CITRUS_HANGING_SIGN.get(), (Block)CITRUS_WALL_HANGING_SIGN.get(), CoreModule.itemProp().m_41487_(Items.f_244406_.m_41459_())));
    @KiwiModule.Category(value={"food"}, after={"chorus_fruit"})
    public static final KiwiGO<Item> TANGERINE = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.TANGERINE)));
    public static final KiwiGO<Item> LIME = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.LIME)));
    public static final KiwiGO<Item> CITRON = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.CITRON)));
    public static final KiwiGO<Item> POMELO = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.POMELO)));
    public static final KiwiGO<Item> ORANGE = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.ORANGE)));
    public static final KiwiGO<Item> LEMON = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.LEMON)));
    public static final KiwiGO<Item> GRAPEFRUIT = CoreModule.go(() -> new ModItem(CoreModule.itemProp().m_41489_(Foods.GRAPEFRUIT)));
    @KiwiModule.Category(value={"natural"}, after={"cherry_leaves"})
    public static final KiwiGO<FruitLeavesBlock> TANGERINE_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.TANGERINE, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> LIME_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.LIME, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> CITRON_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.CITRON, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> POMELO_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.POMELO, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> ORANGE_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.ORANGE, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> LEMON_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.LEMON, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> GRAPEFRUIT_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.GRAPEFRUIT, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    public static final KiwiGO<FruitLeavesBlock> APPLE_LEAVES = CoreModule.go(() -> new FruitLeavesBlock((Supplier<FruitType>)CoreFruitTypes.APPLE, CoreModule.blockProp((BlockBehaviour)Blocks.f_50050_)));
    @KiwiModule.Category(value={"building", "natural"}, after={"cherry_button", "cherry_log"})
    public static final KiwiGO<Block> CITRUS_LOG = CoreModule.go(() -> new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_49999_)));
    @KiwiModule.Category(value={"building"}, after={"fruitfulfun:citrus_log"})
    public static final KiwiGO<Block> CITRUS_WOOD = CoreModule.go(() -> new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50011_)));
    public static final KiwiGO<Block> STRIPPED_CITRUS_LOG = CoreModule.go(() -> new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50010_)));
    public static final KiwiGO<Block> STRIPPED_CITRUS_WOOD = CoreModule.go(() -> new RotatedPillarBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50044_)));
    public static final KiwiGO<Block> CITRUS_PLANKS = CoreModule.go(() -> new ModBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50705_)));
    public static final KiwiGO<Block> CITRUS_STAIRS = CoreModule.go(() -> new StairBlock(((Block)CITRUS_PLANKS.getOrCreate()).m_49966_(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50086_)));
    public static final KiwiGO<Block> CITRUS_SLAB = CoreModule.go(() -> new SlabBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50398_)));
    public static final KiwiGO<Block> CITRUS_FENCE = CoreModule.go(() -> new FenceBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50132_)));
    public static final KiwiGO<Block> CITRUS_FENCE_GATE = CoreModule.go(() -> new FenceGateBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50192_), CITRUS_WOOD_TYPE));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<Block> CITRUS_DOOR = CoreModule.go(() -> new DoorBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50154_), CITRUS_SET_TYPE));
    public static final KiwiGO<Block> CITRUS_TRAPDOOR = CoreModule.go(() -> new TrapDoorBlock(CoreModule.blockProp((BlockBehaviour)Blocks.f_50216_), CITRUS_SET_TYPE));
    public static final KiwiGO<Block> CITRUS_PRESSURE_PLATE = CoreModule.go(() -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, CoreModule.blockProp((BlockBehaviour)Blocks.f_50154_), CITRUS_SET_TYPE));
    public static final KiwiGO<Block> CITRUS_BUTTON = CoreModule.go(() -> Blocks.m_278156_((BlockSetType)CITRUS_SET_TYPE, (FeatureFlag[])new FeatureFlag[0]));
    @KiwiModule.Category(value={"natural"}, after={"cherry_sapling"})
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> TANGERINE_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.TANGERINE.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> LIME_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.LIME.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> CITRON_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.CITRON.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> POMELO_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.POMELO.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> ORANGE_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.ORANGE.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> LEMON_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.LEMON.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> GRAPEFRUIT_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.GRAPEFRUIT.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    public static final KiwiGO<SaplingBlock> APPLE_SAPLING = CoreModule.go(() -> new SaplingBlock((AbstractTreeGrower)new FruitTreeGrower((FruitType)CoreFruitTypes.APPLE.getOrCreate()), CoreModule.blockProp((BlockBehaviour)Blocks.f_50746_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_TANGERINE = CoreModule.go(() -> new FlowerPotBlock((Block)TANGERINE_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_LIME = CoreModule.go(() -> new FlowerPotBlock((Block)LIME_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_CITRON = CoreModule.go(() -> new FlowerPotBlock((Block)CITRON_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_POMELO = CoreModule.go(() -> new FlowerPotBlock((Block)POMELO_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_ORANGE = CoreModule.go(() -> new FlowerPotBlock((Block)ORANGE_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_LEMON = CoreModule.go(() -> new FlowerPotBlock((Block)LEMON_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_GRAPEFRUIT = CoreModule.go(() -> new FlowerPotBlock((Block)GRAPEFRUIT_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    @KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
    @KiwiModule.NoItem
    public static final KiwiGO<Block> POTTED_APPLE = CoreModule.go(() -> new FlowerPotBlock((Block)APPLE_SAPLING.getOrCreate(), CoreModule.blockProp((BlockBehaviour)Blocks.f_50277_)));
    public static final TagKey<Block> ALL_LEAVES = CoreModule.blockTag((String)"fruitfulfun", (String)"leaves");
    public static final KiwiGO<FoliagePlacerType<Fruitify>> FRUITIFY = CoreModule.go(() -> new FoliagePlacerType(Fruitify.CODEC));
    public static final KiwiGO<BannerPattern> SNOWFLAKE = CoreModule.go(() -> new BannerPattern("sno"));
    public static final TagKey<BannerPattern> SNOWFLAKE_TAG = CoreModule.tag((ResourceKey)Registries.f_256969_, (String)"fruitfulfun", (String)"pattern_item/snowflake");
    public static final KiwiGO<BlockEntityType<FruitTreeBlockEntity>> FRUIT_TREE = CoreModule.blockEntity(FruitTreeBlockEntity::new, null, FruitLeavesBlock.class);
    @KiwiModule.Category(value={"ingredients"}, after={"piglin_banner_pattern"})
    public static final KiwiGO<Item> SNOWFLAKE_BANNER_PATTERN = CoreModule.go(() -> new BannerPatternItem(SNOWFLAKE_TAG, CoreModule.itemProp().m_41487_(Items.f_42723_.m_41459_()).m_41497_(Rarity.UNCOMMON)));
    public static final KiwiGO<SoundEvent> OPEN_SOUND = CoreModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("fruitfulfun", "block.wooden_door.open")));
    public static final KiwiGO<SoundEvent> CLOSE_SOUND = CoreModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("fruitfulfun", "block.wooden_door.close")));
    public static final KiwiGO<EntityType<SlidingDoorEntity>> SLIDING_DOOR = CoreModule.go(() -> KiwiEntityTypeBuilder.create().entityFactory(SlidingDoorEntity::new).dimensions(EntityDimensions.m_20395_((float)0.01f, (float)0.01f)).fireImmune().disableSummon().build());
    public static final TagKey<PoiType> POI_TYPE = AbstractModule.tag((ResourceKey)Registries.f_256805_, (String)"fruitfulfun", (String)"trees");
    public static final TagKey<Block> CANDLES = CoreModule.blockTag((String)"fruitfulfun", (String)"candles");

    protected void preInit() {
        CoreModule.createPoiTypes(this);
        CommonProxy.addBuiltinPacks();
    }

    public static void createPoiTypes(AbstractModule module) {
        ModuleInfo info = KiwiModules.get((ResourceLocation)module.uid);
        info.getRegistryEntries((Object)ForgeRegistries.BLOCKS).filter($ -> $.entry instanceof FruitLeavesBlock).forEach($ -> {
            Preconditions.checkArgument((boolean)$.name.m_135815_().endsWith("_leaves"));
            ResourceLocation id = $.name.m_247449_($.name.m_135815_().substring(0, $.name.m_135815_().length() - 7));
            FruitLeavesBlock block = (FruitLeavesBlock)((Object)((Object)$.entry));
            info.register((Object)new PoiType(block.m_49965_().m_61056_().stream().filter(BlockBehaviour.BlockStateBase::m_155947_).collect(Collectors.toSet()), 40, 10), id, (Object)ForgeRegistries.POI_TYPES, null);
        });
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            DispenseItemBehavior original;
            BlockSetType.m_272115_((BlockSetType)CITRUS_SET_TYPE);
            VanillaActions.registerAxeConversion((Block)((Block)CITRUS_LOG.get()), (Block)((Block)STRIPPED_CITRUS_LOG.get()));
            VanillaActions.registerAxeConversion((Block)((Block)CITRUS_WOOD.get()), (Block)((Block)STRIPPED_CITRUS_WOOD.get()));
            for (Holder holder : FFRegistries.FRUIT_TYPE.m_206115_()) {
                ResourceLocation id = ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_();
                FruitType type = (FruitType)holder.m_203334_();
                type.receiveKey(id);
                type.poiType = BuiltInRegistries.f_256941_.m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)id));
                PoiTypes.m_246216_(type.poiType, (Set)((PoiType)type.poiType.m_203334_()).f_27325_());
                VanillaActions.registerCompostable((float)0.5f, (ItemLike)((ItemLike)type.fruit.get()));
                VanillaActions.registerCompostable((float)0.3f, (ItemLike)((ItemLike)type.leaves.get()));
                VanillaActions.registerCompostable((float)0.3f, (ItemLike)((ItemLike)type.sapling.get()));
                VanillaActions.registerVillagerPickupable((ItemLike)((ItemLike)type.fruit.get()));
                VanillaActions.registerVillagerCompostable((ItemLike)((ItemLike)type.fruit.get()));
                VanillaActions.registerVillagerFood((ItemLike)((ItemLike)type.fruit.get()), (int)1);
            }
            KiwiModules.get().stream().filter($ -> $.module.uid.m_135827_().equals("fruitfulfun")).flatMap($ -> $.getRegistryEntries((Object)ForgeRegistries.BLOCKS)).forEach(CoreModule::setFlammability);
            if (FFCommonConfig.dispenserCollectDragonBreath && (original = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42590_)) != null) {
                DispenserBlock.m_52672_((ItemLike)Items.f_42590_, (DispenseItemBehavior)new CollectDragonBreathDispenseBehavior(original));
            }
        });
    }

    private static void setFlammability(NamedEntry<Block> entry) {
        Block block = (Block)entry.entry;
        String path = entry.name.m_135815_();
        if (block instanceof LeavesBlock) {
            VanillaActions.setFireInfo((Block)block, (int)30, (int)60);
        } else if (block instanceof RotatedPillarBlock) {
            VanillaActions.setFireInfo((Block)block, (int)5, (int)5);
        } else if (block instanceof SlabBlock || block instanceof StairBlock || block instanceof FenceBlock || block instanceof FenceGateBlock || path.contains("planks")) {
            VanillaActions.setFireInfo((Block)block, (int)5, (int)20);
        }
    }

    public static final class Foods {
        public static final FoodProperties TANGERINE = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties LIME = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties CITRON = new FoodProperties.Builder().m_38760_(3).m_38758_(0.3f).m_38767_();
        public static final FoodProperties POMELO = new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_();
        public static final FoodProperties ORANGE = new FoodProperties.Builder().m_38760_(3).m_38758_(0.5f).m_38767_();
        public static final FoodProperties LEMON = new FoodProperties.Builder().m_38760_(2).m_38758_(1.0f).m_38766_().m_38767_();
        public static final FoodProperties GRAPEFRUIT = new FoodProperties.Builder().m_38760_(6).m_38758_(0.4f).m_38767_();
    }
}

