/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import snownee.fruits.FruitType;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.fruits.levelgen.foliageplacers.Fruitify;
import snownee.fruits.pomegranate.PomegranateFruitTypes;

public class CoreFruitType
extends FruitType {
    public ResourceKey<ConfiguredFeature<?, ?>> treeFeature;
    public ResourceKey<ConfiguredFeature<?, ?>> treeBeesFeature;
    public ResourceKey<ConfiguredFeature<?, ?>> treeFancyFeature;

    public CoreFruitType(int tier, Supplier<Block> log, Supplier<? extends FruitLeavesBlock> leaves, Supplier<? extends Block> sapling, Supplier<Item> fruit) {
        super(tier, log, leaves, sapling, fruit);
    }

    @Override
    public void receiveKey(ResourceLocation id) {
        this.treeFeature = FeatureUtils.m_255087_((String)id.toString());
        this.treeFancyFeature = FeatureUtils.m_255087_((String)id.m_266382_("_fancy").toString());
        this.treeBeesFeature = FeatureUtils.m_255087_((String)id.m_266382_("_bees").toString());
    }

    @Override
    public void makeFeatures(ResourceLocation id, boolean worldgen, BiConsumer<ResourceLocation, TreeConfiguration> exporter) {
        exporter.accept(id, this.treeBuilder(false, worldgen).m_68251_());
        exporter.accept(id.m_266382_("_fancy"), this.treeBuilder(true, worldgen).m_68251_());
        exporter.accept(id.m_266382_("_bees"), this.treeBuilder(false, worldgen).m_68249_(List.of(new BeehiveDecorator(0.05f))).m_68251_());
    }

    protected TreeConfiguration.TreeConfigurationBuilder treeBuilder(boolean fancy, boolean worldgen) {
        Object foliagePlacer = fancy ? new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)1), 3) : new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.f_146476_, 3);
        StraightTrunkPlacer trunkPlacer = PomegranateFruitTypes.POMEGRANATE.is((Object)this) ? new StraightTrunkPlacer(5, 2, 0) : new StraightTrunkPlacer(4, 2, 0);
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)this.log.get())), (TrunkPlacer)trunkPlacer, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)this.leaves.get())), (FoliagePlacer)new Fruitify((FoliagePlacer)foliagePlacer, worldgen), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_();
    }

    @Override
    public ResourceKey<ConfiguredFeature<?, ?>> getConfiguredFeature(RandomSource pRandom, boolean pLargeHive) {
        if (pRandom.m_188503_(5) == 0) {
            return this.treeFancyFeature;
        }
        return pLargeHive ? this.treeBeesFeature : this.treeFeature;
    }
}

