/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.DisplayAdapter;
import dev.toma.configuration.client.DisplayAdapterManager;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.value.ConfigValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> valueMap;

    public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        this((Component)Component.m_237115_((String)("config.screen." + ownerIdentifier)), configId, valueMap, previous);
    }

    public ConfigScreen(Component screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        super(screenTitle, previous, configId);
        this.valueMap = valueMap;
    }

    protected void m_7856_() {
        int viewportMin = 35;
        int viewportHeight = this.f_96544_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.m_142416_((GuiEventListener)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.f_96543_ - 60, 20, value, this.configId));
            widget.setDescriptionRenderer((graphics, widget1, severity, text) -> this.renderEntryDescription(graphics, widget1, severity, text));
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(value, field, widget);
                this.initializeGuiValue(value, widget);
                continue;
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)field.getType().getSimpleName(), (Object)e);
            }
        }
        this.addFooter();
    }

    private void renderEntryDescription(GuiGraphics graphics, AbstractWidget widget, NotificationSeverity severity, List<FormattedCharSequence> text) {
        int x = widget.m_252754_() + 5;
        int y = widget.m_252907_() + widget.m_93694_() + 10;
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, graphics, text, x, y);
        } else {
            this.renderNotification(NotificationSeverity.INFO, graphics, text, x, y);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)this.f_96539_);
        int n = (this.f_96543_ - titleWidth) / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, this.f_96539_, n, (35 - 9) / 2, 0xFFFFFF, true);
        graphics.m_280509_(0, 35, this.f_96543_, this.f_96544_ - 30, -1728053248);
        ConfigScreen.renderScrollbar(graphics, this.f_96543_ - 5, 35, 5, this.f_96544_ - 30 - 35, this.index, this.valueMap.size(), this.pageSize);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            return true;
        }
        return false;
    }
}

