/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.CompoundFluidIngredient;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
extends Ingredient {
    private List<Fluid> fluids;
    private ItemStack[] cachedStacks;
    private final int amount;
    private final ResourceLocation fluidId;
    private final TagKey<Fluid> fluidTagKey;
    private final CompoundTag nbt;
    private final boolean fuzzyNBT;
    public static final FluidIngredient EMPTY = new FluidIngredient(Collections.emptyList(), 0, null, null, null, false);

    protected FluidIngredient(List<Fluid> fluids, int amount, ResourceLocation fluidId, TagKey<Fluid> fluidTagKey, CompoundTag nbt, boolean fuzzyNBT) {
        super(Stream.empty());
        this.fluids = fluids;
        this.amount = amount;
        this.fluidId = fluidId;
        this.fluidTagKey = fluidTagKey;
        this.nbt = nbt;
        this.fuzzyNBT = fuzzyNBT;
    }

    public static FluidIngredient of(FluidStack fluidStack) {
        return FluidIngredient.of(fluidStack.getAmount(), fluidStack.getTag(), false, fluidStack.getFluid());
    }

    public static FluidIngredient of(int amount, @Nullable CompoundTag nbt, boolean fuzzyNBT, Fluid ... fluids) {
        return new FluidIngredient(Arrays.asList(fluids), amount, null, null, nbt, fuzzyNBT);
    }

    public static FluidIngredient of(int amount, Fluid ... fluids) {
        return FluidIngredient.of(amount, null, false, fluids);
    }

    public static FluidIngredient of(int amount, @Nullable CompoundTag nbt, boolean fuzzyNBT, TagKey<Fluid> fluidTag) {
        return new FluidIngredient(null, amount, null, fluidTag, nbt, fuzzyNBT);
    }

    public static FluidIngredient of(int amount, TagKey<Fluid> fluidTag) {
        return FluidIngredient.of(amount, null, false, fluidTag);
    }

    public static FluidIngredient of(int amount, @Nullable CompoundTag nbt, boolean fuzzyNBT, ResourceLocation fluidId) {
        return new FluidIngredient(null, amount, fluidId, null, nbt, fuzzyNBT);
    }

    public static FluidIngredient of(int amount, ResourceLocation fluidId) {
        return FluidIngredient.of(amount, null, false, fluidId);
    }

    public static FluidIngredient ofFluidStream(Stream<FluidIngredient> stream) {
        return new CompoundFluidIngredient(stream);
    }

    protected Collection<Fluid> getFluidList() {
        if (this.fluids == null) {
            if (this.fluidId != null) {
                this.fluids = ForgeRegistries.FLUIDS.containsKey(this.fluidId) ? Collections.singletonList((Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidId)) : Collections.emptyList();
            } else if (this.fluidTagKey != null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                Objects.requireNonNull(ForgeRegistries.FLUIDS.tags()).getTag(this.fluidTagKey).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.fluids = builder.build();
            } else {
                throw new IllegalStateException("no fluid ID or fluid tag is available?");
            }
        }
        return this.fluids;
    }

    public boolean m_43947_() {
        return this.getFluidList().isEmpty() || this.getFluidList().stream().allMatch(f -> f == Fluids.f_76191_);
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.hasCraftingRemainingItem() && FluidUtil.getFluidContained((ItemStack)stack).map(this::testFluid).orElse(false) != false;
    }

    public ItemStack[] m_43908_() {
        if (this.cachedStacks == null) {
            ArrayList<ItemStack> tankList = new ArrayList<ItemStack>();
            for (Fluid f : this.getFluidList()) {
                FluidStack fluidStack = new FluidStack(f, 1000);
                ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)fluidStack);
                if (!bucket.m_41619_()) {
                    tankList.add(bucket);
                }
                Stream.of("small", "medium", "large", "huge").map(tankName -> (Block)ForgeRegistries.BLOCKS.getValue(PneumaticRegistry.RL(tankName + "_tank"))).filter(tankBlock -> tankBlock != null && tankBlock != Blocks.f_50016_).forEach(tankBlock -> this.maybeAddTank((List<ItemStack>)tankList, (Block)tankBlock, fluidStack));
            }
            this.cachedStacks = tankList.toArray(new ItemStack[0]);
        }
        return this.cachedStacks;
    }

    public boolean testFluid(FluidStack fluidStack) {
        return this.getFluidList().stream().anyMatch(f -> fluidStack.getFluid() == f && fluidStack.getAmount() >= this.getAmount() && this.matchNBT(fluidStack));
    }

    public boolean testFluid(Fluid fluid) {
        return this.getFluidList().stream().anyMatch(f -> f == fluid);
    }

    private void maybeAddTank(List<ItemStack> l, Block tankBlock, FluidStack stack) {
        ItemStack tank = new ItemStack((ItemLike)tankBlock);
        tank.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(h -> {
            h.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            l.add(h.getContainer());
        });
    }

    private boolean matchNBT(FluidStack fluidStack) {
        if (this.nbt == null) {
            return true;
        }
        if (fluidStack.getTag() == null) {
            return false;
        }
        if (this.fuzzyNBT) {
            return this.nbt.m_128431_().stream().allMatch(key -> NbtUtils.m_129235_((Tag)this.nbt.m_128423_(key), (Tag)fluidStack.getTag().m_128423_(key), (boolean)true));
        }
        return NbtUtils.m_129235_((Tag)this.nbt, (Tag)fluidStack.getTag(), (boolean)true);
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        if (this.fluidTagKey != null) {
            json.addProperty("tag", this.fluidTagKey.f_203868_().toString());
        } else if (this.fluidId != null) {
            json.addProperty("fluid", this.fluidId.toString());
        } else if (!this.fluids.isEmpty()) {
            ResourceLocation rl = ForgeRegistries.FLUIDS.getKey((Object)this.fluids.get(0));
            if (rl != null) {
                json.addProperty("fluid", rl.toString());
            }
        } else {
            throw new IllegalStateException("ingredient has no ID, tag or fluid!");
        }
        json.addProperty("amount", (Number)this.getAmount());
        if (this.nbt != null) {
            json.addProperty("nbt", this.nbt.toString());
            json.addProperty("fuzzyNBT", Boolean.valueOf(this.fuzzyNBT));
        }
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<FluidStack> getFluidStacks() {
        return this.getFluidList().stream().map(f -> new FluidStack(f, this.getAmount())).collect(Collectors.toList());
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:fluid");
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public FluidIngredient parse(FriendlyByteBuf buffer) {
            int nFluids = buffer.m_130242_();
            int amount = buffer.m_130242_();
            HashSet<Fluid> fluids = new HashSet<Fluid>();
            for (int i = 0; i < nFluids; ++i) {
                fluids.add((Fluid)buffer.readRegistryIdSafe(Fluid.class));
            }
            if (buffer.readBoolean()) {
                return FluidIngredient.of(amount, buffer.m_130260_(), buffer.readBoolean(), fluids.toArray(new Fluid[0]));
            }
            return FluidIngredient.of(amount, fluids.toArray(new Fluid[0]));
        }

        public FluidIngredient parse(JsonObject json) {
            FluidIngredient result;
            int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1000);
            CompoundTag nbt = this.possibleNBT(json);
            boolean fuzzyNBT = GsonHelper.m_13855_((JsonObject)json, (String)"fuzzyNBT", (boolean)false);
            if (json.has("tag")) {
                ResourceLocation rl = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                result = FluidIngredient.of(amount, nbt, fuzzyNBT, (TagKey<Fluid>)TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)rl));
            } else if (json.has("fluid")) {
                ResourceLocation fluidId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
                if (fluid == null || fluid == Fluids.f_76191_) {
                    throw new JsonSyntaxException("Unknown fluid '" + fluidId + "'");
                }
                result = FluidIngredient.of(amount, nbt, fuzzyNBT, fluid);
            } else {
                throw new JsonSyntaxException("fluid ingredient must have 'fluid' or 'tag' field!");
            }
            return result;
        }

        private CompoundTag possibleNBT(JsonObject json) {
            if (json.has("nbt")) {
                JsonElement element = json.get("nbt");
                try {
                    if (element.isJsonObject()) {
                        return TagParser.m_129359_((String)GSON.toJson(element));
                    }
                    return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
                }
                catch (CommandSyntaxException e) {
                    throw new JsonSyntaxException((Throwable)e);
                }
            }
            return null;
        }

        public void write(FriendlyByteBuf buffer, FluidIngredient ingredient) {
            buffer.m_130130_(ingredient.getFluidList().size());
            buffer.m_130130_(ingredient.getAmount());
            ingredient.getFluidList().forEach(fluid -> buffer.writeRegistryId(ForgeRegistries.FLUIDS, fluid));
            if (ingredient.nbt != null) {
                buffer.writeBoolean(true);
                buffer.m_130079_(ingredient.nbt);
                buffer.writeBoolean(ingredient.fuzzyNBT);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }
}

