/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RenderingCache {
    private static Map<String, BoxPreviewData> boxRenderingCache = new HashMap<String, BoxPreviewData>();
    private static Map<String, BlueprintPreviewData> blueprintRenderingCache = new HashMap<String, BlueprintPreviewData>();

    public static boolean hasBlueprint(String key) {
        return blueprintRenderingCache.containsKey(key);
    }

    public static BoxPreviewData getBoxPreviewData(String key) {
        return boxRenderingCache.get(key);
    }

    public static BlueprintPreviewData getBlueprintPreviewData(String key) {
        return blueprintRenderingCache.get(key);
    }

    public static Collection<BlueprintPreviewData> getBlueprintsToRender() {
        return blueprintRenderingCache.values();
    }

    public static Collection<BoxPreviewData> getBoxesToRender() {
        return boxRenderingCache.values();
    }

    public static void queue(String key, BoxPreviewData boxPreviewData) {
        boxRenderingCache.put(key, boxPreviewData);
    }

    public static void queue(String key, BlueprintPreviewData boxPreviewData) {
        blueprintRenderingCache.put(key, boxPreviewData);
    }

    public static BoxPreviewData removeBox(String key) {
        return boxRenderingCache.remove(key);
    }

    public static BlueprintPreviewData removeBlueprint(String key) {
        return blueprintRenderingCache.remove(key);
    }

    public static BlueprintPreviewData getOrCreateBlueprintPreviewData(String key) {
        return blueprintRenderingCache.computeIfAbsent(key, k -> new BlueprintPreviewData());
    }

    public static boolean forceLightLevel() {
        return (Integer)Structurize.getConfig().getClient().rendererLightLevel.get() >= 0;
    }

    public static int getOurLightLevel() {
        return (Integer)Structurize.getConfig().getClient().rendererLightLevel.get();
    }

    public static void clear() {
        blueprintRenderingCache.clear();
        boxRenderingCache.clear();
    }

    public static void removeSharedPreviews() {
        blueprintRenderingCache.keySet().removeIf(key -> key.startsWith("shared:"));
    }
}

