/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class StructurePackMeta {
    private final String owner;
    private final String packName;
    private final String iconPath;
    private final List<String> authors;
    private final String desc;
    private final List<String> mods;
    private final Path rootPath;
    private final int packFormat;
    private final double version;
    private boolean immutable = false;

    public StructurePackMeta(JsonObject json, Path rootPath, String owner) {
        this.packName = json.get("name").getAsString();
        this.iconPath = json.get("icon").getAsString();
        this.authors = new ArrayList<String>();
        JsonArray authorArray = json.get("authors").getAsJsonArray();
        for (int i = 0; i < authorArray.size(); ++i) {
            this.authors.add(authorArray.get(i).getAsString());
        }
        this.desc = json.get("desc").getAsString();
        this.mods = new ArrayList<String>();
        JsonArray modsArray = json.get("mods").getAsJsonArray();
        for (int i = 0; i < modsArray.size(); ++i) {
            this.mods.add(modsArray.get(i).getAsString());
        }
        this.rootPath = rootPath;
        this.version = json.get("version").getAsDouble();
        this.packFormat = json.get("pack-format").getAsInt();
        this.owner = owner;
    }

    public String getName() {
        return this.packName;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int getPackFormat() {
        return this.packFormat;
    }

    public double getVersion() {
        return this.version;
    }

    public List<String> getModList() {
        return this.mods;
    }

    public Path getPath() {
        return this.rootPath;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSubPath(Path subPath) {
        if (this.rootPath.toString().contains("\\")) {
            return subPath.toString().replace(this.rootPath + "\\", "");
        }
        return subPath.toString().replace(this.rootPath + "/", "");
    }

    public String getNormalizedSubPath(String subPath) {
        if (this.rootPath.toString().contains("\\")) {
            return subPath.replace("/", "\\");
        }
        return subPath.replace("\\", "/");
    }
}

