/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.BlueprintHandler;
import com.ldtteam.structurize.config.AbstractConfiguration;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfiguration
extends AbstractConfiguration {
    public final ForgeConfigSpec.BooleanValue renderPlaceholdersNice;
    public final ForgeConfigSpec.BooleanValue sharePreviews;
    public final ForgeConfigSpec.BooleanValue displayShared;
    public final ForgeConfigSpec.IntValue rendererLightLevel;
    public final ForgeConfigSpec.DoubleValue rendererTransparency;

    protected ClientConfiguration(ForgeConfigSpec.Builder builder) {
        ClientConfiguration.createCategory(builder, "blueprint.renderer");
        this.renderPlaceholdersNice = ClientConfiguration.defineBoolean(builder, "render_placeholders_nice", false);
        this.sharePreviews = ClientConfiguration.defineBoolean(builder, "share_previews", false);
        this.displayShared = ClientConfiguration.defineBoolean(builder, "see_shared_previews", false);
        this.rendererLightLevel = ClientConfiguration.defineInteger(builder, "light_level", 15, -1, 15);
        this.rendererTransparency = ClientConfiguration.defineDouble(builder, "transparency", -1.0, -1.0, 1.0);
        this.addWatcher(BlueprintHandler.getInstance()::clearCache, new ForgeConfigSpec.ConfigValue[]{this.renderPlaceholdersNice, this.rendererLightLevel});
        this.addWatcher(this.displayShared, (T oldValue, T isSharingEnabled) -> {
            Network.getNetwork().sendToServer(new SyncSettingsToServer());
            if (!isSharingEnabled.booleanValue()) {
                RenderingCache.removeSharedPreviews();
            }
        });
        this.addWatcher(this.sharePreviews, (T oldVal, T shouldSharePreviews) -> {
            if (shouldSharePreviews.booleanValue()) {
                RenderingCache.getBlueprintsToRender().forEach(BlueprintPreviewData::syncChangesToServer);
            }
        });
        ClientConfiguration.finishCategory(builder);
    }

    public void collectPreviewRendererSettings(MessagePassingQueue.Consumer<ForgeConfigSpec.ConfigValue<?>> sink) {
        sink.accept((Object)this.sharePreviews);
        sink.accept((Object)this.displayShared);
        sink.accept((Object)this.renderPlaceholdersNice);
        sink.accept((Object)this.rendererLightLevel);
        sink.accept((Object)this.rendererTransparency);
    }
}

