/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.ParticleRegistry;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigClient;
import com.corosus.watut.math.Lerpables;
import com.corosus.watut.particle.ParticleAnimated;
import com.corosus.watut.particle.ParticleRotating;
import com.corosus.watut.particle.ParticleStatic;
import com.corosus.watut.particle.ParticleStaticLoD;
import com.corosus.watut.particle.ParticleStaticPartial;
import com.ibm.icu.impl.Pair;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractCommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.DispenserScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.HopperScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerStatusManagerClient
extends PlayerStatusManager {
    private PlayerStatus selfPlayerStatus = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE);
    private PlayerStatus selfPlayerStatusPrev = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE);
    public HashMap<UUID, PlayerStatus> lookupPlayerToStatusPrev = new HashMap();
    private long typingIdleTimeout = 60L;
    private int armMouseTickRate = 5;
    private int typeRatePollCounter = 0;
    private int steadyTickCounter = 0;
    private int forcedSyncRate = 40;
    private Level lastLevel;
    private boolean wasMousePressed = false;
    private int mousePressedCountdown = 0;

    public void tickGame() {
        ++this.steadyTickCounter;
        if (this.steadyTickCounter == Integer.MAX_VALUE) {
            this.steadyTickCounter = 0;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (Minecraft.m_91087_().m_91403_() != null) {
            Iterator it = this.lookupPlayerToStatus.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_((UUID)entry.getKey());
                PlayerStatus playerStatus = (PlayerStatus)entry.getValue();
                if (playerInfo == null) {
                    WatutMod.dbg("remove playerstatus for no longer existing player: " + entry.getKey());
                    playerStatus.reset();
                    it.remove();
                }
                if (level.m_46003_((UUID)entry.getKey()) != null || playerStatus.getParticle() == null && playerStatus.getParticleIdle() == null) continue;
                WatutMod.dbg("remove player particles for player outside dimension: " + entry.getKey());
                playerStatus.resetParticles();
            }
        }
        if (this.lastLevel != level) {
            WatutMod.dbg("resetting player status");
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("reset player particles for " + entry.getKey() + " hash: " + entry.getValue());
                ((PlayerStatus)entry.getValue()).resetParticles();
            }
            this.selfPlayerStatus.reset();
            this.selfPlayerStatusPrev.reset();
        }
        this.lastLevel = level;
    }

    @Override
    public void tickPlayerClient(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_20148_().equals(player.m_20148_())) {
            this.tickLocalPlayerClient(player);
        }
        this.tickOtherPlayerClient(player);
        this.getStatus(player.m_20148_()).tick();
        PlayerStatus status = this.getStatus(player);
        float adjRateTyping = 0.1f;
        if (status.getTypingAmplifierSmooth() < status.getTypingAmplifier() - adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() + adjRateTyping);
        } else if (status.getTypingAmplifierSmooth() > status.getTypingAmplifier() + adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() - adjRateTyping);
        }
    }

    public void tickLocalPlayerClient(Player player) {
        PlayerStatus.PlayerGuiState playerGuiState;
        Minecraft mc = Minecraft.m_91087_();
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        statusPrevLocal.setPlayerGuiState(statusLocal.getPlayerGuiState());
        if (ConfigClient.sendActiveGui && !statusLocal.isIdle()) {
            if (mc.f_91080_ instanceof ChatScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CHAT_SCREEN);
            } else if (mc.f_91080_ instanceof EffectRenderingInventoryScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.INVENTORY);
            } else if (mc.f_91080_ instanceof CraftingScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CRAFTING);
            } else if (mc.f_91080_ instanceof PauseScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ESCAPE);
            } else if (mc.f_91080_ instanceof BookEditScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.EDIT_BOOK);
            } else if (mc.f_91080_ instanceof AbstractSignEditScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.EDIT_SIGN);
            } else if (mc.f_91080_ instanceof ContainerScreen || mc.f_91080_ instanceof ShulkerBoxScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CHEST);
            } else if (mc.f_91080_ instanceof EnchantmentScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ENCHANTING_TABLE);
            } else if (mc.f_91080_ instanceof AnvilScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ANVIL);
            } else if (mc.f_91080_ instanceof BeaconScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.BEACON);
            } else if (mc.f_91080_ instanceof BrewingStandScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.BREWING_STAND);
            } else if (mc.f_91080_ instanceof DispenserScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.DISPENSER);
            } else if (mc.f_91080_ instanceof AbstractFurnaceScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.FURNACE);
            } else if (mc.f_91080_ instanceof GrindstoneScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.GRINDSTONE);
            } else if (mc.f_91080_ instanceof HopperScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.HOPPER);
            } else if (mc.f_91080_ instanceof HorseInventoryScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.HORSE);
            } else if (mc.f_91080_ instanceof LoomScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.LOOM);
            } else if (mc.f_91080_ instanceof MerchantScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.VILLAGER);
            } else if (mc.f_91080_ instanceof AbstractCommandBlockEditScreen) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.COMMAND_BLOCK);
            } else if (mc.f_91080_ != null) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.MISC);
            } else if (mc.f_91080_ == null) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.NONE);
            }
        } else {
            this.sendGuiStatus(PlayerStatus.PlayerGuiState.NONE);
        }
        String chatText = "";
        Screen screen = mc.f_91080_;
        if (screen instanceof ChatScreen) {
            ChatScreen chatScreen = (ChatScreen)screen;
            chatText = chatScreen.f_95573_.m_94155_();
        } else {
            screen = mc.f_91080_;
            if (screen instanceof BookEditScreen) {
                BookEditScreen bookEditScreen = (BookEditScreen)screen;
                chatText = (String)bookEditScreen.f_98072_.f_95129_.get();
            } else {
                screen = mc.f_91080_;
                if (screen instanceof AbstractSignEditScreen) {
                    AbstractSignEditScreen abstractSignEditScreen = (AbstractSignEditScreen)screen;
                    chatText = (String)abstractSignEditScreen.f_243993_.f_95129_.get();
                } else {
                    screen = mc.f_91080_;
                    if (screen instanceof AbstractCommandBlockEditScreen) {
                        AbstractCommandBlockEditScreen abstractCommandBlockEditScreen = (AbstractCommandBlockEditScreen)screen;
                        chatText = abstractCommandBlockEditScreen.f_97646_.m_94155_();
                    }
                }
            }
        }
        if (this.checkIfTyping(chatText, player)) {
            this.sendChatStatus(PlayerStatus.PlayerChatState.CHAT_TYPING);
        } else if (this.isGuiFocusedOnTextBox(mc.f_91080_)) {
            this.sendChatStatus(PlayerStatus.PlayerChatState.CHAT_FOCUSED);
        } else {
            this.sendChatStatus(PlayerStatus.PlayerChatState.NONE);
        }
        if (ConfigClient.sendMouseInfo && mc.f_91080_ != null && mc.f_91073_.m_46467_() % (long)this.armMouseTickRate == 0L && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState = statusLocal.getPlayerGuiState())) {
            Pair<Float, Float> pos = this.getMousePos();
            if (((Float)pos.first).floatValue() != statusLocal.getScreenPosPercentX() || ((Float)pos.second).floatValue() != statusLocal.getScreenPosPercentY()) {
                this.onAction();
            }
            this.sendMouse(this.getMousePos(), statusLocal.isPressing());
        }
        if (statusPrevLocal.getTicksSinceLastAction() != statusLocal.getTicksSinceLastAction()) {
            statusPrevLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction());
        }
        if (ConfigClient.sendIdleState) {
            statusLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction() + 1);
            if (statusLocal.getTicksSinceLastAction() > statusLocal.getTicksToMarkPlayerIdleSyncedForClient() && statusLocal.isIdle() != statusPrevLocal.isIdle()) {
                WatutMod.dbg("send idle getTicksSinceLastAction: " + statusLocal.getTicksSinceLastAction() + " - " + statusPrevLocal.getTicksSinceLastAction());
                this.sendIdle(statusLocal);
            }
        } else {
            statusLocal.setTicksSinceLastAction(0);
        }
        if (!this.wasMousePressed && this.mousePressedCountdown > 0) {
            --this.mousePressedCountdown;
            if (this.mousePressedCountdown == 0) {
                this.sendMouse(this.getMousePos(), false);
            }
        }
        this.tickSyncing(player);
    }

    public boolean isGuiFocusedOnTextBox(Screen screen) {
        return this.isGuiForceTypeFocused(screen);
    }

    public boolean isGuiForceTypeFocused(Screen screen) {
        return screen instanceof ChatScreen || screen instanceof AbstractSignEditScreen || screen instanceof BookEditScreen || screen instanceof AbstractCommandBlockEditScreen;
    }

    public void tickSyncing(Player player) {
        if (this.steadyTickCounter % this.forcedSyncRate == 0) {
            PlayerStatus playerStatusLocal = this.getStatusLocal();
            this.sendIdle(playerStatusLocal);
            this.sendGuiStatus(playerStatusLocal.getPlayerGuiState(), true);
            this.sendTyping(playerStatusLocal);
        }
    }

    public void onMouse(boolean pressedAnything) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.m_9236_() != null) {
            PlayerStatus.PlayerGuiState playerGuiState = this.getStatus((Player)mc.f_91074_).getPlayerGuiState();
            if (ConfigClient.sendMouseInfo && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState)) {
                if (pressedAnything) {
                    this.mousePressedCountdown = 3;
                    this.wasMousePressed = true;
                } else {
                    this.wasMousePressed = false;
                }
                this.sendMouse(this.getMousePos(), this.mousePressedCountdown > 0);
            }
            if (mc.f_91080_ == null || pressedAnything && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState)) {
                this.onAction();
            }
        }
    }

    public void onKey() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.m_9236_() != null && (mc.f_91080_ == null || this.isGuiFocusedOnTextBox(mc.f_91080_))) {
            this.onAction();
        }
    }

    public void onAction() {
        if (!ConfigClient.sendIdleState) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.m_9236_() != null) {
            PlayerStatus statusLocal = this.getStatusLocal();
            if (statusLocal.isIdle()) {
                statusLocal.setTicksSinceLastAction(0);
                WatutMod.dbg("send idle: 0");
                this.sendIdle(statusLocal);
            } else {
                statusLocal.setTicksSinceLastAction(0);
            }
        }
    }

    public Pair<Float, Float> getMousePos() {
        Minecraft mc = Minecraft.m_91087_();
        double xPercent = mc.f_91067_.m_91589_() / (double)mc.m_91268_().m_85443_() - 0.5;
        double yPercent = mc.f_91067_.m_91594_() / (double)mc.m_91268_().m_85444_() - 0.5;
        double emphasis = 1.5;
        double edgeLimit = 0.5;
        double edgeLimitYLower = 0.2;
        xPercent *= emphasis;
        yPercent *= emphasis;
        xPercent = Math.max(Math.min(xPercent, edgeLimit), -edgeLimit);
        yPercent = Math.min(yPercent, edgeLimitYLower);
        return Pair.of((Object)Float.valueOf((float)xPercent), (Object)Float.valueOf((float)yPercent));
    }

    public boolean checkIfTyping(String input, Player player) {
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        if (statusPrevLocal.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && statusLocal.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeStringForAmp(input);
            statusLocal.setTypingAmplifier(0.0f);
            statusLocal.setLastTypeDiff(0);
            statusLocal.setLastTypeTime(0L);
        }
        ++this.typeRatePollCounter;
        if (input.length() > 0) {
            if (!input.startsWith("/")) {
                if (!input.equals(statusLocal.getLastTypeString())) {
                    statusLocal.setLastTypeString(input);
                    statusLocal.setLastTypeTime(player.m_9236_().m_46467_());
                }
                if (this.typeRatePollCounter >= 10) {
                    this.typeRatePollCounter = 0;
                    int lengthPrev = statusLocal.getLastTypeStringForAmp().length();
                    if (!input.equals(statusLocal.getLastTypeStringForAmp())) {
                        statusLocal.setLastTypeStringForAmp(input);
                        statusLocal.setLastTypeTimeForAmp(player.m_9236_().m_46467_());
                        int length = input.length();
                        int newDiff = length - lengthPrev;
                        float amp = Math.max(0.0f, Math.min(8.0f, (float)newDiff / 6.0f * 2.0f));
                        if (ConfigClient.sendTypingSpeed) {
                            statusLocal.setTypingAmplifier(amp);
                        } else {
                            statusLocal.setTypingAmplifier(1.0f);
                        }
                        this.sendTyping(statusLocal);
                    } else if (ConfigClient.sendTypingSpeed) {
                        statusLocal.setTypingAmplifier(0.0f);
                    }
                }
            }
        } else {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeDiff(0);
            return false;
        }
        return statusLocal.getLastTypeTime() + this.typingIdleTimeout >= player.m_9236_().m_46467_();
    }

    public void onGuiRender() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof ChatScreen && mc.m_91403_() != null && ConfigClient.screenTypingVisible) {
            ChatScreen chat = (ChatScreen)mc.f_91080_;
            GuiGraphics guigraphics = new GuiGraphics(mc, mc.m_91269_().m_110104_());
            int height = chat.f_96544_ + 26;
            guigraphics.m_280488_(mc.f_91062_, WatutMod.getPlayerStatusManagerClient().getTypingPlayers(), 2 + ConfigClient.screenTypingRelativePosition_X, height - 50 + ConfigClient.screenTypingRelativePosition_Y, 0xFFFFFF);
            guigraphics.m_280262_();
        }
    }

    public String getTypingPlayers() {
        Minecraft mc = Minecraft.m_91087_();
        Object str = "";
        for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
            GameProfile profile;
            PlayerInfo info;
            if (((PlayerStatus)entry.getValue()).getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_SCREEN || ((PlayerStatus)entry.getValue()).getPlayerChatState() != PlayerStatus.PlayerChatState.CHAT_TYPING || (info = mc.m_91403_().m_104949_((UUID)entry.getKey())) == null || (profile = info.m_105312_()) == null) continue;
            str = (String)str + profile.getName() + ", ";
        }
        int playersLengthStr = ((String)str).length();
        Object anim = "";
        int animRate = 6;
        for (long time = mc.f_91073_.m_46467_() % (long)(animRate * 4); time > (long)animRate; time -= (long)animRate) {
            anim = (String)anim + ".";
        }
        if (playersLengthStr > ConfigClient.screenTypingCharacterLimit) {
            str = ConfigClient.screenTypingMultiplePlayersText + (String)anim;
        } else if (((String)str).length() > 2) {
            str = ((String)str).substring(0, ((String)str).length() - 2) + " is typing" + (String)anim;
        }
        return str;
    }

    public boolean shouldAnimate(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        return player != mc.f_91074_ || !mc.f_91066_.m_92176_().m_90612_();
    }

    public void tickOtherPlayerClient(Player player) {
        Vec3 posParticle;
        ParticleRotating particle;
        boolean statusChatParticleChangeOrGone;
        PlayerStatus playerStatus = this.getStatus(player);
        PlayerStatus playerStatusPrev = this.getStatusPrev(player);
        long stableTime = this.steadyTickCounter;
        float sin = (float)Math.sin((float)stableTime / 30.0f % 360.0f);
        float cos = (float)Math.cos((float)stableTime / 30.0f % 360.0f);
        float idleY = (float)(2.6 + (double)(cos * 0.03f));
        boolean idleParticleChangeOrGone = playerStatus.isIdle() != playerStatusPrev.isIdle() || playerStatus.getParticleIdle() == null;
        boolean statusParticleChangeOrGone = playerStatus.getPlayerGuiState() != playerStatusPrev.getPlayerGuiState() || playerStatus.getParticle() == null;
        boolean bl = statusChatParticleChangeOrGone = playerStatus.getPlayerChatState() != playerStatusPrev.getPlayerChatState() && playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_SCREEN;
        if ((idleParticleChangeOrGone || !playerStatus.isIdle()) && playerStatus.getParticleIdle() != null) {
            playerStatus.getParticleIdle().m_107274_();
            playerStatus.setParticleIdle(null);
        }
        if ((statusParticleChangeOrGone || statusChatParticleChangeOrGone || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) && playerStatus.getParticle() != null) {
            playerStatus.getParticle().m_107274_();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticle() != null && !playerStatus.getParticle().m_107276_()) {
            playerStatus.getParticle().m_107274_();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticleIdle() != null && !playerStatus.getParticleIdle().m_107276_()) {
            playerStatus.getParticleIdle().m_107274_();
            playerStatus.setParticleIdle(null);
        }
        double quadSize = (double)0.3f + Math.sin((float)stableTime / 10.0f % 360.0f) * (double)0.01f;
        if (this.shouldAnimate(player)) {
            if (idleParticleChangeOrGone && ConfigClient.showIdleStatesInPlayerAboveHead && playerStatus.isIdle() && (particle = new ParticleStatic((ClientLevel)player.m_9236_(), player.m_20182_().f_82479_, player.m_20182_().f_82480_ + (double)idleY, player.m_20182_().f_82481_, ParticleRegistry.idle.getSprite())) != null) {
                playerStatus.setParticleIdle((Particle)particle);
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)particle);
                particle.setQuadSize((float)quadSize);
                WatutMod.dbg("spawning idle particle for " + player.m_20148_());
            }
            if (statusParticleChangeOrGone || statusChatParticleChangeOrGone) {
                particle = null;
                posParticle = this.getParticlePosition(player);
                if (ConfigClient.showPlayerActiveChatGui && PlayerStatus.PlayerGuiState.isTypingGui(this.getStatus(player).getPlayerGuiState())) {
                    if (this.getStatus(player).getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_FOCUSED) {
                        particle = new ParticleAnimated((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.chat_idle.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING) {
                        particle = new ParticleAnimated((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.chat_typing.getSpriteSet());
                    }
                }
                if (ConfigClient.showPlayerActiveNonChatGui) {
                    TextureAtlasSprite sprite = null;
                    float brightness = 0.7f;
                    int subSizeX = 0;
                    int subSizeY = 0;
                    if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.INVENTORY) {
                        particle = new ParticleStaticLoD((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.inventory.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CRAFTING) {
                        particle = new ParticleStaticLoD((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.crafting.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ESCAPE) {
                        particle = new ParticleStaticLoD((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.escape.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHEST) {
                        particle = new ParticleStaticLoD((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.chest.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.EDIT_BOOK) {
                        particle = new ParticleStatic((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.book.getSprite(), 0.7f);
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.EDIT_SIGN) {
                        particle = new ParticleStatic((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.sign.getSprite(), 0.7f);
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ENCHANTING_TABLE) {
                        sprite = ParticleRegistry.enchanting_table.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ANVIL) {
                        sprite = ParticleRegistry.anvil.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.BEACON) {
                        sprite = ParticleRegistry.beacon.getSprite();
                        subSizeX = 231;
                        subSizeY = 219;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.BREWING_STAND) {
                        sprite = ParticleRegistry.brewing_stand.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.DISPENSER) {
                        sprite = ParticleRegistry.dispenser.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.FURNACE) {
                        sprite = ParticleRegistry.furnace.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.GRINDSTONE) {
                        sprite = ParticleRegistry.grindstone.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.HOPPER) {
                        sprite = ParticleRegistry.hopper.getSprite();
                        subSizeX = 176;
                        subSizeY = 134;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.HORSE) {
                        sprite = ParticleRegistry.horse.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.LOOM) {
                        sprite = ParticleRegistry.loom.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.VILLAGER) {
                        sprite = ParticleRegistry.villager.getSprite();
                        subSizeX = 277;
                        subSizeY = 167;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.COMMAND_BLOCK) {
                        sprite = ParticleRegistry.command_block.getSprite();
                        subSizeX = 308;
                        subSizeY = 213;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.MISC && ConfigClient.showPlayerActiveGuiIfNotExactMatch) {
                        particle = new ParticleStaticLoD((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, ParticleRegistry.chest.getSpriteSet());
                    }
                    if (sprite != null) {
                        particle = new ParticleStaticPartial((ClientLevel)player.m_9236_(), posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_, sprite, brightness, subSizeX, subSizeY);
                    }
                }
                if (particle != null) {
                    playerStatus.setParticle((Particle)particle);
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)particle);
                }
            }
        }
        if (playerStatus.getParticleIdle() != null && (particle = (ParticleStatic)playerStatus.getParticleIdle()).m_107276_()) {
            particle.keepAlive();
            particle.m_107264_(player.m_20182_().f_82479_, player.m_20182_().f_82480_ + (double)idleY, player.m_20182_().f_82481_);
            particle.setPosPrev(player.m_20182_().f_82479_, player.m_20182_().f_82480_ + (double)idleY, player.m_20182_().f_82481_);
            particle.m_172260_(0.0, 0.0, 0.0);
            ((ParticleStatic)particle).prevRotationYaw = ((ParticleStatic)particle).rotationYaw = -player.f_20883_ + 180.0f;
            ((ParticleStatic)particle).prevRotationRoll = ((ParticleStatic)particle).rotationRoll = cos * 5.0f;
            particle.setQuadSize(0.15f + sin * 0.03f);
            particle.m_107271_(0.5f);
        }
        if (playerStatus.getParticle() != null && playerStatus.getParticle() instanceof ParticleRotating && (particle = (ParticleRotating)playerStatus.getParticle()).m_107276_()) {
            particle.keepAlive();
            posParticle = this.getParticlePosition(player);
            particle.m_107264_(posParticle.f_82479_, posParticle.f_82480_, posParticle.f_82481_);
            particle.m_172260_(0.0, 0.0, 0.0);
            if (!(playerStatus.getParticle() instanceof ParticleAnimated)) {
                particle.setQuadSize((float)quadSize);
                if (Minecraft.m_91087_().f_91075_ != null) {
                    double distToCamera = Minecraft.m_91087_().f_91075_.m_20270_((Entity)player);
                    double distToCameraCapped = Math.max(3.0, Math.min(10.0, distToCamera));
                    float alpha = (float)Math.max((double)0.35f, 1.0 - distToCameraCapped / 10.0);
                    particle.m_107271_(alpha);
                    if (particle instanceof ParticleStaticLoD) {
                        ((ParticleStaticLoD)particle).setParticleFromDistanceToCamera((float)distToCamera);
                    }
                } else {
                    particle.m_107271_(0.5f);
                }
            }
            particle.prevRotationYaw = particle.rotationYaw = -player.f_20883_;
            particle.prevRotationPitch = particle.rotationPitch = 20.0f;
        }
        playerStatusPrev.setPlayerGuiState(playerStatus.getPlayerGuiState());
        playerStatusPrev.setPlayerChatState(playerStatus.getPlayerChatState());
        if (playerStatusPrev.getTicksSinceLastAction() != playerStatus.getTicksSinceLastAction()) {
            playerStatusPrev.setTicksSinceLastAction(playerStatus.getTicksSinceLastAction());
        }
    }

    public boolean renderPingIconHook(PlayerTabOverlay playerTabOverlay, GuiGraphics pGuiGraphics, int p_281809_, int p_282801_, int pY, PlayerInfo pPlayerInfo) {
        if (Minecraft.m_91087_().f_91061_ == null || pPlayerInfo == null || pPlayerInfo.m_105312_() == null || !ConfigClient.showIdleStatesInPlayerList) {
            return false;
        }
        PlayerStatus playerStatus = this.getStatus(pPlayerInfo.m_105312_().getId());
        if (playerStatus.isIdle()) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 101.0f);
            TextureAtlasSprite sprite = ParticleRegistry.idle.getSprite();
            int x = (int)((float)Minecraft.m_91087_().f_91061_.f_107296_.f_276067_ * sprite.m_118409_());
            int y = (int)((float)Minecraft.m_91087_().f_91061_.f_107296_.f_276070_ * sprite.m_118411_());
            pGuiGraphics.m_280163_(sprite.m_247685_(), p_282801_ + p_281809_ - 11, pY, (float)x, (float)y, 10, 8, Minecraft.m_91087_().f_91061_.f_107296_.f_276067_, Minecraft.m_91087_().f_91061_.f_107296_.f_276070_);
            pGuiGraphics.m_280168_().m_85849_();
            return true;
        }
        return false;
    }

    public void setupRotationsHook(EntityModel model, Entity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!ConfigClient.showPlayerAnimations) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean inOwnInventory = pEntity == mc.f_91074_ && mc.f_91080_ instanceof EffectRenderingInventoryScreen && pEntity.m_6084_();
        boolean isRealPlayer = pEntity.m_9236_().m_6907_().contains(pEntity);
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            if (pEntity instanceof Player) {
                Player player = (Player)pEntity;
                if (isRealPlayer && (!inOwnInventory && this.shouldAnimate((Player)pEntity) || this.singleplayerTesting)) {
                    boolean contextIsInventoryPaperDoll;
                    PlayerStatus playerStatus = this.getStatus(player);
                    boolean bl = contextIsInventoryPaperDoll = (double)playerModel.f_102808_.f_104204_ > Math.PI;
                    if (!contextIsInventoryPaperDoll) {
                        if (playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                            playerStatus.yRotHeadBeforeOverriding = playerModel.f_102808_.f_104204_;
                            playerStatus.xRotHeadBeforeOverriding = playerModel.f_102808_.f_104203_;
                            if (player.m_9236_().m_46467_() % 5L == 0L) {
                                // empty if block
                            }
                        } else if ((double)playerModel.f_102808_.f_104204_ <= Math.PI) {
                            playerStatus.yRotHeadWhileOverriding = playerModel.f_102808_.f_104204_;
                            playerStatus.xRotHeadWhileOverriding = playerModel.f_102808_.f_104203_;
                        }
                    }
                    if (playerStatus.isLerping() || playerStatus.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE || playerStatus.isIdle()) {
                        float partialTick;
                        playerStatus.lastPartialTick = partialTick = pAgeInTicks - (float)((int)pAgeInTicks);
                        playerModel.f_102811_.f_104204_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.yRot, (float)playerStatus.getLerpTarget().rightArm.yRot);
                        playerModel.f_102811_.f_104203_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.xRot, (float)playerStatus.getLerpTarget().rightArm.xRot);
                        playerModel.f_102811_.f_104200_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.x, (float)playerStatus.getLerpTarget().rightArm.x);
                        playerModel.f_102811_.f_104201_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.y, (float)playerStatus.getLerpTarget().rightArm.y);
                        playerModel.f_102811_.f_104202_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.z, (float)playerStatus.getLerpTarget().rightArm.z);
                        playerModel.f_102812_.f_104204_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.yRot, (float)playerStatus.getLerpTarget().leftArm.yRot);
                        playerModel.f_102812_.f_104203_ += Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.xRot, (float)playerStatus.getLerpTarget().leftArm.xRot);
                        float yRotDiff = playerStatus.getLerpTarget().head.yRot - playerStatus.getLerpPrev().head.yRot;
                        if ((double)Math.abs(yRotDiff) < 1.5707963267948966) {
                            playerModel.f_102808_.f_104204_ = Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.yRot, (float)playerStatus.getLerpTarget().head.yRot);
                            if (player.m_9236_().m_46467_() % 5L == 0L) {
                                // empty if block
                            }
                        }
                        playerModel.f_102808_.f_104203_ = Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.xRot, (float)playerStatus.getLerpTarget().head.xRot);
                        playerModel.f_102808_.f_104205_ = Mth.m_14179_((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.zRot, (float)playerStatus.getLerpTarget().head.zRot);
                        playerModel.f_103375_.f_104204_ = playerModel.f_102811_.f_104204_;
                        playerModel.f_103375_.f_104203_ = playerModel.f_102811_.f_104203_;
                        playerModel.f_103375_.f_104200_ = playerModel.f_102811_.f_104200_;
                        playerModel.f_103375_.f_104201_ = playerModel.f_102811_.f_104201_;
                        playerModel.f_103375_.f_104202_ = playerModel.f_102811_.f_104202_;
                        playerModel.f_103374_.f_104204_ = playerModel.f_102812_.f_104204_;
                        playerModel.f_103374_.f_104203_ = playerModel.f_102812_.f_104203_;
                        playerModel.f_102809_.f_104203_ = playerModel.f_102808_.f_104203_;
                        playerModel.f_102809_.f_104204_ = playerModel.f_102808_.f_104204_;
                        if (ConfigClient.showPlayerAnimation_Typing && playerStatus.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING) {
                            float amp = playerStatus.getTypingAmplifierSmooth();
                            float typeAngle = (float)Math.toRadians(Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                            float typeAngle2 = (float)Math.toRadians(-Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                            playerModel.f_102811_.f_104203_ -= typeAngle;
                            playerModel.f_103375_.f_104203_ -= typeAngle;
                            playerModel.f_102812_.f_104203_ -= typeAngle2;
                            playerModel.f_103374_.f_104203_ -= typeAngle2;
                        }
                        if (ConfigClient.showPlayerAnimation_Idle && playerStatus.isIdle()) {
                            float angle = (float)Math.toRadians(Math.sin(pAgeInTicks * 0.05f % 360.0f) * 15.0);
                            float angle2 = (float)Math.toRadians(Math.cos(pAgeInTicks * 0.05f % 360.0f) * 7.0);
                            playerModel.f_102808_.f_104203_ += angle2;
                            playerModel.f_102808_.f_104205_ += angle;
                        }
                    }
                    playerModel.f_102809_.f_104203_ = playerModel.f_102808_.f_104203_;
                    playerModel.f_102809_.f_104204_ = playerModel.f_102808_.f_104204_;
                    playerModel.f_102809_.f_104205_ = playerModel.f_102808_.f_104205_;
                }
            }
        }
    }

    public void setPoseTarget(UUID uuid, boolean becauseMousePress) {
        PlayerStatus playerStatus = this.getStatus(uuid);
        playerStatus.getLerpPrev().rightArm = playerStatus.getLerpTarget().rightArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().rightArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().leftArm = playerStatus.getLerpTarget().leftArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().leftArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().head = playerStatus.getLerpTarget().head.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().head, playerStatus.lastPartialTick);
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.yRot)) {
            playerStatus.getLerpPrev().rightArm.yRot = 0.0f;
        }
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.xRot)) {
            playerStatus.getLerpPrev().rightArm.xRot = 0.0f;
        }
        boolean pointing = PlayerStatus.PlayerGuiState.isPointingGui(playerStatus.getPlayerGuiState());
        boolean typing = playerStatus.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING;
        boolean idle = playerStatus.isIdle();
        if (!ConfigClient.showPlayerAnimation_Gui) {
            pointing = false;
        }
        if (!ConfigClient.showPlayerAnimation_Typing) {
            typing = false;
        }
        if (!ConfigClient.showPlayerAnimation_Idle) {
            idle = false;
        }
        if (becauseMousePress) {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 0.5f);
        } else {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 1.0f);
        }
        if (pointing || typing) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(15.0);
            playerStatus.getLerpTarget().head.yRot = 0.0f;
        }
        if (pointing) {
            double xPercent = playerStatus.getScreenPosPercentX();
            double yPercent = playerStatus.getScreenPosPercentY();
            double x = Math.toRadians(90.0) - Math.toRadians(22.5) - yPercent;
            double y = -Math.toRadians(15.0) + xPercent;
            playerStatus.getLerpTarget().rightArm.yRot = (float)y;
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            if (playerStatus.isPressing()) {
                Vec3 vec = this.calculateViewVector((float)Math.toDegrees(y), (float)Math.toDegrees(x));
                float press = 1.0f;
                playerStatus.getLerpTarget().rightArm.x = (float)((double)press * vec.f_82480_);
                playerStatus.getLerpTarget().rightArm.y = (float)((double)press * vec.f_82481_);
                playerStatus.getLerpTarget().rightArm.z = (float)((double)press * vec.f_82479_);
            } else {
                playerStatus.getLerpTarget().rightArm.x = 0.0f;
                playerStatus.getLerpTarget().rightArm.z = 0.0f;
                playerStatus.getLerpTarget().rightArm.y = 0.0f;
            }
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-Math.toRadians(70.0));
            playerStatus.getLerpTarget().leftArm.yRot = (float)Math.toRadians(25.0);
        } else if (typing) {
            double x = Math.toRadians(90.0) - Math.toRadians(22.5);
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-x);
            double tiltIn = Math.toRadians(20.0);
            playerStatus.getLerpTarget().rightArm.yRot = (float)(-tiltIn);
            playerStatus.getLerpTarget().leftArm.yRot = (float)tiltIn;
        }
        if (!(pointing || typing || idle)) {
            playerStatus.setLerpTarget(new Lerpables());
            playerStatus.getLerpTarget().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpTarget().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
        if (idle) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(70.0);
            playerStatus.setNewLerp(40.0f);
        }
        if (this.getStatusPrev(uuid).getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && this.getStatus(uuid).getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            playerStatus.getLerpPrev().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpPrev().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
    }

    public Vec3 getParticlePosition(Player player) {
        Vec3 pos = player.m_20182_();
        float distFromFace = 0.75f;
        Vec3 lookVec = this.getBodyAngle(player).m_82490_((double)distFromFace);
        return new Vec3(pos.f_82479_ + lookVec.f_82479_, pos.f_82480_ + 1.2, pos.f_82481_ + lookVec.f_82481_);
    }

    public Vec3 getBodyAngle(Player player) {
        return this.calculateViewVector(player.m_146909_(), player.f_20883_);
    }

    public Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    @Override
    public PlayerStatus getStatusLocal() {
        return this.selfPlayerStatus;
    }

    public PlayerStatus getStatusPrevLocal() {
        return this.selfPlayerStatusPrev;
    }

    public PlayerStatus getStatusPrev(Player player) {
        return this.getStatusPrev(player.m_20148_());
    }

    public PlayerStatus getStatusPrev(UUID uuid) {
        return this.getStatusPrev(uuid, false);
    }

    public PlayerStatus getStatusPrev(UUID uuid, boolean local) {
        if (local) {
            return this.getStatusPrevLocal();
        }
        this.checkPrev(uuid);
        return this.lookupPlayerToStatusPrev.get(uuid);
    }

    public void checkPrev(UUID uuid) {
        if (!this.lookupPlayerToStatusPrev.containsKey(uuid)) {
            this.lookupPlayerToStatusPrev.put(uuid, new PlayerStatus(PlayerStatus.PlayerGuiState.NONE));
        }
    }

    public void sendGuiStatus(PlayerStatus.PlayerGuiState playerStatus) {
        this.sendGuiStatus(playerStatus, false);
    }

    public void sendGuiStatus(PlayerStatus.PlayerGuiState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerGuiState() != playerStatus || force) {
            CompoundTag data = new CompoundTag();
            data.m_128405_(WatutNetworking.NBTDataPlayerGuiStatus, playerStatus.ordinal());
            CULog.dbg((String)("sending status from client: " + playerStatus + " for " + Minecraft.m_91087_().f_91074_.m_20148_()));
            CULog.dbg((String)("data: " + data));
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerGuiState(playerStatus);
    }

    public void sendChatStatus(PlayerStatus.PlayerChatState playerStatus) {
        this.sendChatStatus(playerStatus, false);
    }

    public void sendChatStatus(PlayerStatus.PlayerChatState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerChatState() != playerStatus || force) {
            CompoundTag data = new CompoundTag();
            data.m_128405_(WatutNetworking.NBTDataPlayerChatStatus, playerStatus.ordinal());
            CULog.dbg((String)("sending chat status from client: " + playerStatus + " for " + Minecraft.m_91087_().f_91074_.m_20148_()));
            CULog.dbg((String)("data: " + data));
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerChatState(playerStatus);
    }

    public void sendMouse(Pair<Float, Float> pos, boolean pressed) {
        Minecraft mc = Minecraft.m_91087_();
        float x = ((Float)pos.first).floatValue();
        float y = ((Float)pos.second).floatValue();
        if (mc.f_91073_.m_5788_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (double)this.nearbyPlayerDataSendDist, entity -> entity != mc.f_91074_) != null && (this.getStatusLocal().getScreenPosPercentX() != x || this.getStatusLocal().getScreenPosPercentY() != y || this.getStatusLocal().isPressing() != pressed)) {
            CompoundTag data = new CompoundTag();
            data.m_128350_(WatutNetworking.NBTDataPlayerMouseX, x);
            data.m_128350_(WatutNetworking.NBTDataPlayerMouseY, y);
            data.m_128379_(WatutNetworking.NBTDataPlayerMousePressed, pressed);
            CULog.dbg((String)("sending mouse status from client for " + Minecraft.m_91087_().f_91074_.m_20148_()));
            CULog.dbg((String)("data: " + data));
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setScreenPosPercentX(x);
        this.getStatusLocal().setScreenPosPercentY(y);
        this.getStatusLocal().setPressing(pressed);
    }

    public void sendTyping(PlayerStatus status) {
        CompoundTag data = new CompoundTag();
        data.m_128350_(WatutNetworking.NBTDataPlayerTypingAmp, status.getTypingAmplifier());
        CULog.dbg((String)("sending typing amp from client for " + Minecraft.m_91087_().f_91074_.m_20148_()));
        CULog.dbg((String)("data: " + data));
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void sendIdle(PlayerStatus status) {
        CompoundTag data = new CompoundTag();
        data.m_128405_(WatutNetworking.NBTDataPlayerIdleTicks, status.getTicksSinceLastAction());
        CULog.dbg((String)("sending idle ticks from client for " + Minecraft.m_91087_().f_91074_.m_20148_()));
        CULog.dbg((String)("data: " + data));
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void receiveAny(UUID uuid, CompoundTag data) {
        PlayerStatus status = this.getStatus(uuid);
        PlayerStatus statusPrev = this.getStatusPrev(uuid);
        if (data.m_128441_(WatutNetworking.NBTDataPlayerTypingAmp)) {
            status.setTypingAmplifier(data.m_128457_(WatutNetworking.NBTDataPlayerTypingAmp));
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerMouseX)) {
            Player player;
            float x = data.m_128457_(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.m_128457_(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.m_128471_(WatutNetworking.NBTDataPlayerMousePressed);
            boolean differentPress = status.isPressing() != pressed;
            this.setMouse(uuid, x, y, pressed);
            this.setPoseTarget(uuid, differentPress);
            if (pressed && differentPress && (player = Minecraft.m_91087_().f_91073_.m_46003_(uuid)) != null && ConfigClient.playMouseClickSounds && player != Minecraft.m_91087_().f_91074_) {
                WatutMod.dbg("play sound for " + uuid + " name " + player.m_5446_().getString());
                player.m_9236_().m_245747_(player.m_20097_(), SoundEvents.f_11752_, SoundSource.PLAYERS, 0.05f, 0.1f, false);
            }
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerGuiStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.m_128451_(WatutNetworking.NBTDataPlayerGuiStatus));
            status.setPlayerGuiState(playerGuiState);
            if (status.getPlayerGuiState() != statusPrev.getPlayerGuiState()) {
                WatutMod.dbg("New gui player state and new pose target set relating to: " + status.getPlayerGuiState() + " for " + uuid);
                if (statusPrev.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                    status.setLerpTarget(new Lerpables());
                }
                this.setPoseTarget(uuid, false);
                Player player = Minecraft.m_91087_().f_91073_.m_46003_(uuid);
                if (player != null && ConfigClient.playScreenOpenSounds && player != Minecraft.m_91087_().f_91074_) {
                    PlayerStatus.PlayerGuiState playerGuiStatePrev = statusPrev.getPlayerGuiState();
                    if (PlayerStatus.PlayerGuiState.isSoundMakerGui(playerGuiState) || PlayerStatus.PlayerGuiState.isSoundMakerGui(playerGuiStatePrev) || playerGuiState == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiState == PlayerStatus.PlayerGuiState.MISC || playerGuiStatePrev == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiStatePrev == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiStatePrev == PlayerStatus.PlayerGuiState.MISC) {
                        player.m_9236_().m_245747_(player.m_20097_(), SoundEvents.f_11672_, SoundSource.PLAYERS, 0.9f, 1.0f, false);
                    }
                }
            }
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerChatStatus)) {
            PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.m_128451_(WatutNetworking.NBTDataPlayerChatStatus));
            status.setPlayerChatState(state);
            if (status.getPlayerChatState() != statusPrev.getPlayerChatState()) {
                WatutMod.dbg("New chat player state and new pose target set relating to: " + status.getPlayerChatState() + " for " + uuid);
                if (statusPrev.getPlayerChatState() == PlayerStatus.PlayerChatState.NONE) {
                    status.setLerpTarget(new Lerpables());
                }
                if (status.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_FOCUSED) {
                    status.setTypingAmplifier(1.0f);
                    status.setTypingAmplifierSmooth(1.0f);
                }
                this.setPoseTarget(uuid, false);
            }
        }
        if (data.m_128441_(WatutNetworking.NBTDataPlayerIdleTicks)) {
            status.setTicksSinceLastAction(data.m_128451_(WatutNetworking.NBTDataPlayerIdleTicks));
            status.setTicksToMarkPlayerIdleSyncedForClient(data.m_128451_(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            statusPrev.setTicksToMarkPlayerIdleSyncedForClient(data.m_128451_(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            this.getStatusLocal().setTicksToMarkPlayerIdleSyncedForClient(data.m_128451_(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            this.getStatusPrevLocal().setTicksToMarkPlayerIdleSyncedForClient(data.m_128451_(WatutNetworking.NBTDataPlayerTicksToGoIdle));
            if (statusPrev.isIdle() != status.isIdle()) {
                WatutMod.dbg("New idle player state and new pose target set relating to idle state: " + status.isIdle() + " for " + uuid);
                this.setPoseTarget(uuid, false);
            }
        }
    }
}

