/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.crafting.serializers.SimpleRecipeSerializer;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class IERepairItemRecipe
extends CustomRecipe {
    public IERepairItemRecipe(ResourceLocation name) {
        super(name, CraftingBookCategory.MISC);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.findInputSlots(inv).isPresent();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        return this.findInputSlots(inv).map(p -> this.combineStacks((ItemStack)p.getFirst(), (ItemStack)p.getSecond())).orElse(ItemStack.f_41583_);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)(inv.m_39346_() * inv.m_39347_()), (Object)ItemStack.f_41583_);
    }

    @Nonnull
    public RecipeSerializer<IERepairItemRecipe> m_7707_() {
        return Objects.requireNonNull((SimpleRecipeSerializer)RecipeSerializers.IE_REPAIR_SERIALIZER.get());
    }

    private Optional<Pair<ItemStack, ItemStack>> findInputSlots(CraftingContainer inv) {
        Optional<Object> first = Optional.empty();
        Optional<Object> second = Optional.empty();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (!this.isValidInput(stack)) {
                return Optional.empty();
            }
            if (first.isPresent() && second.isPresent()) {
                return Optional.empty();
            }
            if (first.isPresent()) {
                ItemStack existing = (ItemStack)first.get();
                if (existing.m_41720_() != stack.m_41720_()) {
                    return Optional.empty();
                }
                second = Optional.of(stack);
                continue;
            }
            first = Optional.of(stack);
        }
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(Pair.of((Object)((ItemStack)first.get()), (Object)((ItemStack)second.get())));
        }
        return Optional.empty();
    }

    private boolean isValidInput(ItemStack in) {
        return in.m_41720_() instanceof IEBaseItem && ((IEBaseItem)in.m_41720_()).isIERepairable(in);
    }

    private ItemStack combineStacks(ItemStack a, ItemStack b) {
        int remainingA = a.m_41776_() - a.m_41773_();
        int remainingB = a.m_41776_() - b.m_41773_();
        int remainingResult = remainingA + remainingB + a.m_41776_() * 5 / 100;
        int damageResult = a.m_41776_() - remainingResult;
        if (damageResult < 0) {
            damageResult = 0;
        }
        ItemStack result = new ItemStack((ItemLike)a.m_41720_());
        result.m_41721_(damageResult);
        return result;
    }
}

