/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.common.util.IELogger;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.forgespi.language.IModInfo;

public class OptifineWarning {
    public static void warnIfRequired() {
        if (OptifineWarning.detectBadOptifine()) {
            IModInfo modInfo = ModLoadingContext.get().getActiveContainer().getModInfo();
            ModLoadingWarning warning = new ModLoadingWarning(modInfo, ModLoadingStage.CONSTRUCT, "immersiveengineering.optifinePoseStackWarning", new Object[0]);
            ModLoader.get().addWarning(warning);
        }
    }

    private static boolean detectBadOptifine() {
        try {
            Class.forName("net.optifine.Config");
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        try {
            PoseStack stack = new PoseStack();
            stack.pushTransformation(new Transformation(null));
            return false;
        }
        catch (NoSuchMethodError x) {
            IELogger.logger.error("Detected bad Optifine version, error is:", (Throwable)x);
            return true;
        }
    }
}

