/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.registry;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultiblockPartBlock<State extends IMultiblockState>
extends Block
implements EntityBlock {
    private final MultiblockRegistration<State> multiblock;
    private final boolean needsServerTicker;
    private final boolean needsClientTicker;

    public MultiblockPartBlock(BlockBehaviour.Properties properties, MultiblockRegistration<State> multiblock) {
        super(properties.m_60988_());
        this.multiblock = multiblock;
        boolean hasMirrorProperty = this.m_49965_().m_61092_().contains(IEProperties.MIRRORED);
        Preconditions.checkState((this.multiblock.mirrorable() == hasMirrorProperty ? 1 : 0) != 0);
        this.needsServerTicker = multiblock.logic() instanceof IServerTickableComponent ? true : multiblock.extraComponents().stream().map(MultiblockRegistration.ExtraComponent::component).anyMatch(c -> c instanceof IServerTickableComponent);
        this.needsClientTicker = multiblock.logic() instanceof IClientTickableComponent ? true : multiblock.extraComponents().stream().map(MultiblockRegistration.ExtraComponent::component).anyMatch(c -> c instanceof IClientTickableComponent);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IEProperties.MULTIBLOCKSLAVE});
        builder.m_61104_(new Property[]{IEProperties.FACING_HORIZONTAL});
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (((Boolean)state.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) {
            return this.multiblock.dummyBE().get().m_155264_(pos, state);
        }
        return this.multiblock.masterBE().get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> actual) {
        if (((Boolean)state.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE)).booleanValue()) {
            return null;
        }
        if (level.f_46443_ && this.needsClientTicker) {
            return this.createTickerHelper(actual, ($1, $2, $3, blockEntity) -> blockEntity.getHelper().tickClient());
        }
        if (!level.f_46443_ && this.needsServerTicker) {
            return this.createTickerHelper(actual, ($1, $2, $3, blockEntity) -> blockEntity.getHelper().tickServer());
        }
        return null;
    }

    @Nullable
    protected <A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> actual, BlockEntityTicker<MultiblockBlockEntityMaster<State>> ticker) {
        return this.multiblock.masterBE().get() == actual ? ticker : null;
    }

    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getShape(level, pos, context, ShapeType.COLLISION);
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getShape(level, pos, context, ShapeType.SELECTION);
    }

    @Nonnull
    public VoxelShape m_7947_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return this.getShape(level, pos, null, ShapeType.BLOCK_SUPPORT);
    }

    @Nonnull
    private VoxelShape getShape(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nullable CollisionContext context, @Nonnull ShapeType type) {
        BlockEntity bEntity = level.m_7702_(pos);
        if (bEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)bEntity;
            return multiblockBE.getHelper().getShape(context, type);
        }
        return Shapes.m_83144_();
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            super.m_6810_(state, level, pos, newState, isMoving);
            multiblockBE.getHelper().disassemble();
            return;
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity bEntity = level.m_7702_(pos);
        if (bEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)bEntity;
            return multiblockBE.getHelper().click(player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        BlockEntity bEntity = level.m_7702_(pos);
        if (bEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)bEntity;
            multiblockBE.getHelper().onEntityCollided(entity);
        }
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return this.multiblock.hasComparatorOutput();
    }

    public int m_6782_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        BlockEntity blockEntity;
        if (this.multiblock.hasComparatorOutput() && (blockEntity = level.m_7702_(pos)) instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            return multiblockBE.getHelper().getComparatorValue();
        }
        return super.m_6782_(state, level, pos);
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (this.multiblock.redstoneInputAware() && (blockEntity = level.m_7702_(pos)) instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            multiblockBE.getHelper().onNeighborChanged(fromPos);
        }
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)blockEntity;
            return multiblockBE.getHelper().getPickBlock();
        }
        return ItemStack.f_41583_;
    }

    public static class WithMirrorState<State extends IMultiblockState>
    extends MultiblockPartBlock<State> {
        public WithMirrorState(BlockBehaviour.Properties properties, MultiblockRegistration<State> multiblock) {
            super(properties, multiblock);
        }

        @Override
        protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{IEProperties.MIRRORED});
        }
    }
}

