/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api.container;

import java.util.Arrays;
import net.blay09.mods.balm.api.container.EmptyContainer;
import net.blay09.mods.balm.api.container.ExtractionAwareContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CombinedContainer
implements Container,
ExtractionAwareContainer {
    private final Container[] containers;
    private final int[] baseIndex;
    private final int totalSlots;

    public CombinedContainer(Container ... containers) {
        this.containers = containers;
        this.baseIndex = new int[containers.length];
        int index = 0;
        for (int i = 0; i < containers.length; ++i) {
            this.baseIndex[i] = index += containers[i].m_6643_();
        }
        this.totalSlots = index;
    }

    private int getContainerIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    private Container getContainerFromIndex(int index) {
        return index >= 0 && index < this.containers.length ? this.containers[index] : EmptyContainer.INSTANCE;
    }

    private int getSlotFromIndex(int slot, int index) {
        return index > 0 && index < this.baseIndex.length ? slot - this.baseIndex[index - 1] : slot;
    }

    public int m_6643_() {
        return this.totalSlots;
    }

    public boolean m_7983_() {
        return Arrays.stream(this.containers).allMatch(Container::m_7983_);
    }

    public ItemStack m_8020_(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        Container container = this.getContainerFromIndex(containerIndex);
        return container.m_8020_(this.getSlotFromIndex(slot, containerIndex));
    }

    public ItemStack m_7407_(int slot, int amount) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        Container container = this.getContainerFromIndex(containerIndex);
        return container.m_7407_(this.getSlotFromIndex(slot, containerIndex), amount);
    }

    public ItemStack m_8016_(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        Container container = this.getContainerFromIndex(containerIndex);
        return container.m_8016_(this.getSlotFromIndex(slot, containerIndex));
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        Container container = this.getContainerFromIndex(containerIndex);
        container.m_6836_(this.getSlotFromIndex(slot, containerIndex), itemStack);
    }

    public void m_6596_() {
        for (Container container : this.containers) {
            container.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return Arrays.stream(this.containers).allMatch(container -> container.m_6542_(player));
    }

    public void m_6211_() {
        for (Container container : this.containers) {
            container.m_6211_();
        }
    }

    @Override
    public boolean canExtractItem(int slot) {
        int containerIndex = this.getContainerIndexForSlot(slot);
        Container container = this.getContainerFromIndex(containerIndex);
        if (container instanceof ExtractionAwareContainer) {
            ExtractionAwareContainer extractionAwareContainer = (ExtractionAwareContainer)container;
            return extractionAwareContainer.canExtractItem(this.getSlotFromIndex(slot, containerIndex));
        }
        return true;
    }
}

