/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.projector;

import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.util.ModUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public final class PyramidProjectorMode
implements ProjectorMode {
    @Override
    public Set<Vec3> getExteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        int xStretch = posScale.m_123341_() + negScale.m_123341_();
        int yStretch = posScale.m_123342_() + negScale.m_123342_();
        int zStretch = posScale.m_123343_() + negScale.m_123343_();
        Vec3 translation = new Vec3(0.0, (double)(-negScale.m_123342_()), 0.0);
        int inverseThickness = 8;
        for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
            for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
                for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                    double yTest = y / (float)yStretch * (float)inverseThickness;
                    double xzPositivePlane = (1.0f - x / (float)xStretch - z / (float)zStretch) * (float)inverseThickness;
                    double xzNegativePlane = (1.0f + x / (float)xStretch - z / (float)zStretch) * (float)inverseThickness;
                    if (x >= 0.0f && z >= 0.0f && Math.round(xzPositivePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)z).m_82549_(translation));
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)(-z)).m_82549_(translation));
                    }
                    if (x <= 0.0f && z >= 0.0f && Math.round(xzNegativePlane) == Math.round(yTest)) {
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)(-z)).m_82549_(translation));
                        fieldBlocks.add(new Vec3((double)x, (double)y, (double)z).m_82549_(translation));
                    }
                    if (y != 0.0f || !((double)(Math.abs(x) + Math.abs(z)) < (double)(xStretch + yStretch) / 2.0)) continue;
                    fieldBlocks.add(new Vec3((double)x, (double)y, (double)z).m_82549_(translation));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vec3> getInteriorPoints(Projector projector) {
        HashSet<Vec3> fieldBlocks = new HashSet<Vec3>();
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        BlockPos projectorPos = projector.be().m_58899_();
        int xStretch = posScale.m_123341_() + negScale.m_123341_();
        int yStretch = posScale.m_123342_() + negScale.m_123342_();
        int zStretch = posScale.m_123343_() + negScale.m_123343_();
        Vec3 translation = new Vec3(0.0, -0.4, 0.0);
        for (float x = (float)(-xStretch); x <= (float)xStretch; x += 1.0f) {
            for (float z = (float)(-zStretch); z <= (float)zStretch; z += 1.0f) {
                for (float y = 0.0f; y <= (float)yStretch; y += 1.0f) {
                    Vec3 position = new Vec3((double)x, (double)y, (double)z).m_82549_(translation);
                    if (!this.isInField(projector, position.m_82520_((double)projectorPos.m_123341_(), (double)projectorPos.m_123342_(), (double)projectorPos.m_123343_()))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(Projector projector, Vec3 position) {
        BlockPos posScale = projector.getPositiveScale();
        BlockPos negScale = projector.getNegativeScale();
        int xStretch = posScale.m_123341_() + negScale.m_123341_();
        int yStretch = posScale.m_123342_() + negScale.m_123342_();
        int zStretch = posScale.m_123343_() + negScale.m_123343_();
        BlockPos projectorPos = projector.be().m_58899_().m_121955_((Vec3i)projector.getTranslation()).m_7918_(0, -negScale.m_123342_(), 0);
        Vec3 relativePosition = position.m_82492_((double)projectorPos.m_123341_(), (double)projectorPos.m_123342_(), (double)projectorPos.m_123343_());
        Vec3 relativeRotated = ModUtil.rotateByAngleExact(relativePosition, -projector.getRotationYaw(), -projector.getRotationPitch(), 0.0);
        Vec3 min = Vec3.m_82528_((Vec3i)negScale.m_142393_(-1));
        return PyramidProjectorMode.isIn(min, Vec3.m_82528_((Vec3i)posScale), relativeRotated) && relativeRotated.m_7098_() > 0.0 && 1.0 - Math.abs(relativeRotated.m_7096_()) / (double)xStretch - Math.abs(relativeRotated.m_7094_()) / (double)zStretch > relativeRotated.m_7098_() / (double)yStretch;
    }

    private static boolean isIn(Vec3 min, Vec3 max, Vec3 vec) {
        return vec.m_7096_() > min.m_7096_() && vec.m_7096_() < max.m_7096_() && vec.m_7098_() > min.m_7098_() && vec.m_7098_() < max.m_7098_() && vec.m_7094_() > min.m_7094_() && vec.m_7094_() < max.m_7094_();
    }
}

