/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.FrequencyBlock;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.TargetPosPair;
import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.setup.ModBlocks;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.FrequencyGrid;
import dev.su5ed.mffs.util.module.BaseModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FusionModule
extends BaseModule {
    private final List<BlockPos> removingBlocks = new ArrayList<BlockPos>();

    public FusionModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public void beforeSelect(Projector projector, Collection<? extends TargetPosPair> field) {
        int frequency = (Integer)projector.be().getCapability(ModCapabilities.FORTRON).map(FrequencyBlock::getFrequency).orElseThrow();
        Level level = projector.be().m_58904_();
        for (FortronStorage storage : FrequencyGrid.instance(level.f_46443_).get(frequency)) {
            storage.getOwner().getCapability(ModCapabilities.PROJECTOR).filter(compareProjector -> compareProjector != projector && compareProjector.be().m_58904_() == level && compareProjector.isActive() && compareProjector.getMode().isPresent()).ifPresent(compareProjector -> {
                Iterator it = field.iterator();
                while (it.hasNext()) {
                    BlockPos pos = ((TargetPosPair)it.next()).pos();
                    if (!compareProjector.getMode().orElseThrow().isInField((Projector)compareProjector, Vec3.m_82528_((Vec3i)pos))) continue;
                    this.removingBlocks.add(pos);
                    it.remove();
                }
            });
        }
    }

    @Override
    public void beforeProject(Projector projector) {
        Level level = projector.be().m_58904_();
        for (BlockPos pos : this.removingBlocks) {
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_((Block)ModBlocks.FORCE_FIELD.get())) continue;
            level.m_7471_(pos, false);
        }
        this.removingBlocks.clear();
    }
}

