/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.api.security.InterdictionMatrix;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.module.BaseInterdictionModule;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import one.util.streamex.StreamEx;

public class ConfiscationModule
extends BaseInterdictionModule {
    public ConfiscationModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public boolean onDefend(InterdictionMatrix interdictionMatrix, LivingEntity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            BiometricIdentifier identifier = interdictionMatrix.getBiometricIdentifier();
            if (identifier != null && identifier.isAccessGranted(player, FieldPermission.BYPASS_CONFISCATION)) {
                return false;
            }
        }
        BiometricIdentifier identifier = interdictionMatrix.getBiometricIdentifier();
        if (target instanceof Player) {
            Player player = (Player)target;
            if (identifier == null || !identifier.isAccessGranted(player, FieldPermission.BYPASS_DEFENSE)) {
                Inventory inventory = player.m_150109_();
                Collection<ItemStack> filteredItems = interdictionMatrix.getFilteredItems();
                int confiscationCount = 0;
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack checkStack = inventory.m_8020_(i);
                    if (checkStack.m_41619_()) continue;
                    boolean stacksMatch = StreamEx.of(filteredItems).anyMatch(stack -> ItemStack.m_41656_((ItemStack)stack, (ItemStack)checkStack));
                    InterdictionMatrix.ConfiscationMode mode = interdictionMatrix.getConfiscationMode();
                    if ((mode != InterdictionMatrix.ConfiscationMode.BLACKLIST || !stacksMatch) && (mode != InterdictionMatrix.ConfiscationMode.WHITELIST || stacksMatch)) continue;
                    interdictionMatrix.mergeIntoInventory(inventory.m_8020_(i));
                    inventory.m_6836_(i, ItemStack.f_41583_);
                    ++confiscationCount;
                }
                if (confiscationCount > 0) {
                    player.m_5661_((Component)ModUtil.translate("info", "interdiction_matrix.confiscation_" + (confiscationCount == 1 ? "singular" : "plural"), interdictionMatrix.getTitle(), confiscationCount), false);
                    int finalConfiscationCount = confiscationCount;
                    interdictionMatrix.be().getCapability(ModCapabilities.FORTRON).ifPresent(fortron -> fortron.extractFortron(finalConfiscationCount, false));
                }
            }
        }
        return false;
    }
}

